/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.converter;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class GenericDisplayConverter
implements IDisplayConverter {
    private LabelProviderCellContextElementWrapper contextElement = new LabelProviderCellContextElementWrapper();

    public Object canonicalToDisplayValue(Object canonicalValue) {
        throw new UnsupportedOperationException();
    }

    public Object displayToCanonicalValue(Object displayValue) {
        return displayValue.toString();
    }

    public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        if (canonicalValue == null) {
            return null;
        }
        LabelProviderService service = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = service.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider");
        this.contextElement.setConfigRegistry(configRegistry);
        this.contextElement.setCell(cell);
        this.contextElement.setObject(canonicalValue);
        Assert.isNotNull((Object)labelProvider);
        return labelProvider.getText((Object)this.contextElement);
    }

    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
        return displayValue;
    }
}

