/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationObservationHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.TimeConstraintHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.TimeObservationHelper;
import org.eclipse.papyrus.uml.service.types.helper.advice.InteractionFragmentEditHelperAdvice;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class OccurrenceSpecificationHelperAdvice
extends InteractionFragmentEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ArrayList<Object> dependentsToDestroy = new ArrayList<Object>();
        OccurrenceSpecification os = (OccurrenceSpecification)request.getElementToDestroy();
        InteractionFragment containerPackage = (InteractionFragment)os.getOwner();
        if (containerPackage != null) {
            TreeIterator contentIterator = containerPackage.eAllContents();
            while (contentIterator.hasNext()) {
                EObject currentEObject = (EObject)contentIterator.next();
                if (currentEObject instanceof Message) {
                    Message m = (Message)currentEObject;
                    if (os.equals(m.getSendEvent())) {
                        dependentsToDestroy.add(m);
                        if (m.getReceiveEvent() != null) {
                            dependentsToDestroy.add(m.getReceiveEvent());
                        }
                    }
                    if (os.equals(m.getReceiveEvent())) {
                        dependentsToDestroy.add(m);
                        if (m.getSendEvent() != null) {
                            dependentsToDestroy.add(m.getSendEvent());
                        }
                    }
                }
                if (!(currentEObject instanceof ExecutionSpecification)) continue;
                ExecutionSpecification exec = (ExecutionSpecification)currentEObject;
                if (os.equals(exec.getStart())) {
                    dependentsToDestroy.add(exec);
                    if (exec.getFinish() != null && !(exec.getFinish() instanceof MessageEnd)) {
                        dependentsToDestroy.add(exec.getFinish());
                    }
                }
                if (!os.equals(exec.getFinish())) continue;
                dependentsToDestroy.add(exec);
                if (exec.getStart() == null || exec.getStart() instanceof MessageEnd) continue;
                dependentsToDestroy.add(exec.getStart());
            }
        }
        dependentsToDestroy.addAll(TimeObservationHelper.getTimeObservations((NamedElement)os));
        dependentsToDestroy.addAll(TimeConstraintHelper.getTimeConstraintsOn((NamedElement)os));
        dependentsToDestroy.addAll(DurationObservationHelper.getDurationObservationsOn((NamedElement)os));
        dependentsToDestroy.addAll(DurationConstraintHelper.getDurationConstraintsOn((NamedElement)os));
        dependentsToDestroy.addAll((Collection<Object>)os.getToBefores());
        dependentsToDestroy.addAll((Collection<Object>)os.getToAfters());
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }
}

