/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.util;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.environment.EnvironmentPackage;
import org.eclipse.papyrus.infra.properties.environment.Namespace;
import org.eclipse.papyrus.infra.properties.environment.WidgetType;
import org.eclipse.papyrus.infra.properties.ui.Widget;
import org.eclipse.papyrus.infra.properties.ui.runtime.IConfigurationManager;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesUtil;
import org.eclipse.papyrus.infra.tools.util.Iterators2;

public class WidgetTypeHelper {
    private static final String NAMESPACE = "org.eclipse.papyrus.infra.properties.ui.widgets";
    private final IConfigurationManager configManager = PropertiesRuntime.getConfigurationManager();
    private Optional<Namespace> coreWidgetNamespace;

    private WidgetTypeHelper() {
    }

    public static final WidgetTypeHelper getInstance(Widget widget) {
        return WidgetTypeHelper.getInstance(EMFHelper.getResourceSet((EObject)widget));
    }

    public static final WidgetTypeHelper getInstance(Property property) {
        return WidgetTypeHelper.getInstance(EMFHelper.getResourceSet((EObject)property));
    }

    private static final WidgetTypeHelper getInstance(ResourceSet resourceSet) {
        HelperAdapter adapter = (HelperAdapter)EcoreUtil.getExistingAdapter((Notifier)resourceSet, HelperAdapter.class);
        if (adapter == null) {
            adapter = new HelperAdapter(new WidgetTypeHelper());
            resourceSet.eAdapters().add((Object)adapter);
        }
        return adapter.getHelper();
    }

    public WidgetType getDefaultWidgetType(Property property) {
        return this.configManager.getDefaultEditorType(property);
    }

    public boolean isCoreWidgetType(WidgetType widgetType) {
        return widgetType != null && widgetType.getNamespace() == this.getCoreWidgetNamespace();
    }

    public Namespace getCoreWidgetNamespace() {
        if (this.coreWidgetNamespace == null) {
            Predicate<Notifier> shouldPrune = Predicate.not(arg_0 -> ((EClass)EnvironmentPackage.Literals.ENVIRONMENT).isInstance(arg_0)).and(EObject.class::isInstance);
            this.coreWidgetNamespace = Iterators2.stream((TreeIterator)this.configManager.getResourceSet().getAllContents(), shouldPrune).filter(Namespace.class::isInstance).map(Namespace.class::cast).filter(ns -> PropertiesUtil.namespaceEquals((Namespace)ns, (String)NAMESPACE)).findFirst();
        }
        return this.coreWidgetNamespace.orElse(null);
    }

    private static final class HelperAdapter
    extends AdapterImpl {
        private final WidgetTypeHelper helper;

        HelperAdapter(WidgetTypeHelper helper) {
            this.helper = helper;
        }

        WidgetTypeHelper getHelper() {
            return this.helper;
        }

        public boolean isAdapterForType(Object type) {
            return type == WidgetTypeHelper.class || type == HelperAdapter.class;
        }
    }
}

