/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AbstractEditHelperAdviceConfiguration;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ConfigurationElement;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.uml.profile.types.generator.ConfigurationSetRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.papyrus.uml.profile.types.generator.strategy.ElementTypeConfigHelper;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherFactory;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeMatcherAdviceConfiguration;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ElementTypeRule {
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Extension
    private static StereotypeApplicationMatcherFactory stereotypeApplicationMatcherConfigurationFactory = StereotypeApplicationMatcherFactory.eINSTANCE;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private ElementTypeConfigHelper _elementTypeConfigHelper;
    private final HashMap<ArrayList<?>, SpecializationTypeConfiguration> _createCache_toElementType = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, StereotypeMatcherAdviceConfiguration> _createCache_toMatcherConfiguration = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecializationTypeConfiguration toElementType(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        SpecializationTypeConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, supertype});
        HashMap<ArrayList<?>, SpecializationTypeConfiguration> hashMap = this._createCache_toElementType;
        synchronized (hashMap) {
            SpecializationTypeConfiguration _createSpecializationTypeConfiguration;
            if (this._createCache_toElementType.containsKey(_cacheKey)) {
                return this._createCache_toElementType.get(_cacheKey);
            }
            _result = _createSpecializationTypeConfiguration = elementtypesconfigurationsFactory.createSpecializationTypeConfiguration();
            this._createCache_toElementType.put(_cacheKey, _result);
        }
        this._init_toElementType(_result, umlExtension, supertype);
        return _result;
    }

    private void _init_toElementType(SpecializationTypeConfiguration it, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        boolean _not;
        ElementTypeConfiguration elemTypeConfigFromRegistry;
        it.setIdentifier(this._identifiers.toElementTypeID(umlExtension, supertype));
        boolean _hasSemanticSupertype = this._uMLElementTypes.hasSemanticSupertype(supertype);
        if (_hasSemanticSupertype) {
            String baseTypeId = this._identifiers.toSemanticElementTypeID(umlExtension, this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass()));
            IElementType baseTypeFromRegistry = ElementTypeRegistry.getInstance().getType(baseTypeId);
            if (baseTypeFromRegistry instanceof ConfiguredHintedSpecializationElementType) {
                ElementTypeConfiguration baseType = ((ConfiguredHintedSpecializationElementType)baseTypeFromRegistry).getConfiguration();
                it.getSpecializedTypes().add((Object)baseType);
            } else {
                SpecializationTypeConfiguration baseType_1 = elementtypesconfigurationsFactory.createSpecializationTypeConfiguration();
                baseType_1.setIdentifier(this._identifiers.toElementTypeID(umlExtension, this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass())));
                baseType_1.getSpecializedTypes().add((Object)this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass()));
                baseType_1.setHint(this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass()).getHint());
                baseType_1.setName(this._identifiers.toElementTypeName(umlExtension, this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass())));
                IconEntry icon = this.getIconEntry(umlExtension.getStereotype());
                IconEntry _xifexpression = null;
                boolean _notEquals = !Objects.equals(icon, null);
                _xifexpression = _notEquals ? icon : this._uMLElementTypes.getIconEntry(umlExtension.getMetaclass());
                baseType_1.setIconEntry(_xifexpression);
                ElementTypeConfiguration addedBaseType = ConfigurationSetRule.addElementType((ElementTypeConfiguration)baseType_1);
                it.getSpecializedTypes().add((Object)addedBaseType);
            }
        }
        it.getSpecializedTypes().add((Object)supertype);
        it.setHint(supertype.getHint());
        it.setName(this._identifiers.toElementTypeName(umlExtension, supertype));
        this._elementTypeConfigHelper.setSource((ConfigurationElement)it, EcoreUtil.getURI((EObject)umlExtension.getStereotype()).toString());
        IElementType elemTypeFromRegistry = ElementTypeRegistry.getInstance().getType(it.getIdentifier());
        if (elemTypeFromRegistry instanceof ConfiguredHintedSpecializationElementType && (elemTypeConfigFromRegistry = ((ConfiguredHintedSpecializationElementType)elemTypeFromRegistry).getConfiguration()) instanceof SpecializationTypeConfiguration) {
            boolean _notEquals_1;
            AbstractEditHelperAdviceConfiguration helperAdviceFromRegistry = ((SpecializationTypeConfiguration)elemTypeConfigFromRegistry).getEditHelperAdviceConfiguration();
            boolean bl = _notEquals_1 = !Objects.equals(helperAdviceFromRegistry, null);
            if (_notEquals_1) {
                it.setEditHelperAdviceConfiguration(helperAdviceFromRegistry);
            }
        }
        IconEntry icon_1 = this.getIconEntry(umlExtension.getStereotype());
        IconEntry _xifexpression_1 = null;
        boolean _notEquals_2 = !Objects.equals(icon_1, null);
        _xifexpression_1 = _notEquals_2 ? icon_1 : this._uMLElementTypes.getIconEntry(umlExtension.getMetaclass());
        it.setIconEntry(_xifexpression_1);
        boolean _hasSemanticSupertype_1 = this._uMLElementTypes.hasSemanticSupertype(supertype);
        boolean bl = _not = !_hasSemanticSupertype_1;
        if (_not) {
            it.setMatcherConfiguration((AbstractMatcherConfiguration)this.toMatcherConfiguration(umlExtension, supertype));
        }
    }

    public void setStereotypeName(ElementTypeConfiguration typeConfig, Stereotype stereotype) {
        AbstractMatcherConfiguration matcher;
        boolean _notEquals;
        String newName = stereotype.getQualifiedName();
        ImpliedExtension ext = this._elementTypeConfigHelper.getExtension(typeConfig, stereotype);
        if (ext == null) {
            return;
        }
        List<AbstractAdviceBindingConfiguration> advices = new ElementTypeConfigHelper().getRelatedAdvices(typeConfig);
        int _size = advices.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            return;
        }
        AbstractAdviceBindingConfiguration advice = advices.get(0);
        if (advice instanceof ApplyStereotypeAdviceConfiguration) {
            boolean _equals;
            int _size_1 = ((ApplyStereotypeAdviceConfiguration)advice).getStereotypesToApply().size();
            boolean bl2 = _equals = _size_1 == 1;
            if (_equals) {
                boolean _equals_1;
                StereotypeToApply stereotypeToApply = (StereotypeToApply)((ApplyStereotypeAdviceConfiguration)advice).getStereotypesToApply().get(0);
                stereotypeToApply.setStereotypeQualifiedName(newName);
                int _size_2 = stereotypeToApply.getRequiredProfiles().size();
                boolean bl3 = _equals_1 = _size_2 == 1;
                if (_equals_1) {
                    boolean _notEquals_1;
                    String profileName = this.getProfileName(newName);
                    boolean bl4 = _notEquals_1 = !Objects.equals(profileName, null);
                    if (_notEquals_1) {
                        stereotypeToApply.getRequiredProfiles().set(0, (Object)profileName);
                    }
                }
            }
        } else if (advice instanceof StereotypeMatcherAdviceConfiguration) {
            boolean _equals_2;
            int _size_3 = ((StereotypeMatcherAdviceConfiguration)advice).getStereotypesQualifiedNames().size();
            boolean bl5 = _equals_2 = _size_3 == 1;
            if (_equals_2) {
                ((StereotypeMatcherAdviceConfiguration)advice).getStereotypesQualifiedNames().set(0, (Object)newName);
            }
        }
        if (typeConfig instanceof SpecializationTypeConfiguration && (matcher = ((SpecializationTypeConfiguration)typeConfig).getMatcherConfiguration()) instanceof StereotypeApplicationMatcherConfiguration) {
            boolean _equals_3;
            int _size_4 = ((StereotypeApplicationMatcherConfiguration)matcher).getStereotypesQualifiedNames().size();
            boolean bl6 = _equals_3 = _size_4 == 1;
            if (_equals_3) {
                ((StereotypeApplicationMatcherConfiguration)matcher).getStereotypesQualifiedNames().set(0, (Object)newName);
            }
        }
        if (typeConfig instanceof SpecializationTypeConfiguration) {
            ElementTypeConfiguration supertype = (ElementTypeConfiguration)((SpecializationTypeConfiguration)typeConfig).getSpecializedTypes().get(0);
            ((SpecializationTypeConfiguration)typeConfig).setName(this._identifiers.toElementTypeName(ext, supertype));
            ((SpecializationTypeConfiguration)typeConfig).setIdentifier(this._identifiers.toElementTypeID(ext, supertype));
        }
    }

    private String getProfileName(String stereoName) {
        int sep = stereoName.lastIndexOf("::");
        if (sep > 0) {
            String profileName = stereoName.substring(0, sep);
            return profileName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StereotypeMatcherAdviceConfiguration toMatcherConfiguration(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        StereotypeMatcherAdviceConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, supertype});
        HashMap<ArrayList<?>, StereotypeMatcherAdviceConfiguration> hashMap = this._createCache_toMatcherConfiguration;
        synchronized (hashMap) {
            StereotypeMatcherAdviceConfiguration _createStereotypeMatcherAdviceConfiguration;
            if (this._createCache_toMatcherConfiguration.containsKey(_cacheKey)) {
                return this._createCache_toMatcherConfiguration.get(_cacheKey);
            }
            _result = _createStereotypeMatcherAdviceConfiguration = stereotypeApplicationMatcherConfigurationFactory.createStereotypeMatcherAdviceConfiguration();
            this._createCache_toMatcherConfiguration.put(_cacheKey, _result);
        }
        this._init_toMatcherConfiguration(_result, umlExtension, supertype);
        return _result;
    }

    private void _init_toMatcherConfiguration(StereotypeMatcherAdviceConfiguration it, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        Stereotype umlStereotype = umlExtension.getStereotype();
        String _qualified = this._identifiers.getQualified(StringExtensions.toFirstLower((String)umlStereotype.getName()));
        String _hintSuffix = this._identifiers.hintSuffix(supertype);
        String _plus = _qualified + _hintSuffix;
        it.setIdentifier(_plus);
        it.getStereotypesQualifiedNames().add((Object)umlStereotype.getQualifiedName());
        String _name = umlStereotype.getName();
        String _plus_1 = "Apply Stereotype " + _name;
        it.setDescription(_plus_1);
    }

    private IconEntry getIconEntry(Stereotype stereotype) {
        boolean _notEquals;
        IconEntry _xblockexpression = null;
        Functions.Function1 _function = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getLocation());
            return !_isNullOrEmpty;
        };
        Image image = (Image)IterableExtensions.findFirst((Iterable)stereotype.getIcons(), (Functions.Function1)_function);
        IconEntry _xifexpression = null;
        boolean bl = _notEquals = !Objects.equals(image, null);
        if (_notEquals) {
            boolean _notEquals_1;
            IconEntry _xblockexpression_1 = null;
            URI uri = URI.createURI((String)image.getLocation(), (boolean)true);
            IconEntry _xifexpression_1 = null;
            boolean bl2 = _notEquals_1 = !Objects.equals(uri, null);
            if (_notEquals_1) {
                IconEntry _createIconEntry = elementtypesconfigurationsFactory.createIconEntry();
                Procedures.Procedure1 _function_1 = it -> {
                    boolean _isPlatform = uri.isPlatform();
                    if (_isPlatform) {
                        it.setBundleId(uri.segment(1));
                        Functions.Function1 _function_2 = it_1 -> URI.decode((String)it_1);
                        String _join = IterableExtensions.join((Iterable)IterableExtensions.drop((Iterable)uri.segmentsList(), (int)2), (CharSequence)"/", (Functions.Function1)_function_2);
                        String _plus = "/" + _join;
                        it.setIconPath(_plus);
                    } else {
                        boolean _isRelative = uri.isRelative();
                        if (_isRelative) {
                            it.setBundleId(this.containingProject((EObject)stereotype).getName());
                            String _decode = URI.decode((String)uri.toString());
                            String _plus_1 = "/" + _decode;
                            it.setIconPath(_plus_1);
                        } else {
                            it.setIconPath(uri.toString());
                        }
                    }
                };
                _xifexpression_1 = (IconEntry)ObjectExtensions.operator_doubleArrow((Object)_createIconEntry, (Procedures.Procedure1)_function_1);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private IProject containingProject(EObject object) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(object.eResource().getURI().segment(2));
    }
}

