/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.service.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkSpecificObject;
import org.eclipse.papyrus.infra.hyperlink.service.HyperlinkContributor;
import org.eclipse.papyrus.infra.hyperlink.service.HyperlinkService;

public class HyperlinkServiceImpl
implements HyperlinkService {
    public static final String IS_ACTIVE_KEY = "isActive";
    protected ServicesRegistry registry;
    private List<HyperlinkContributorDescriptor> hyperlinkContributors;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.createHyperlinkContributors();
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
    }

    protected void createHyperlinkContributors() {
        IConfigurationElement[] config;
        this.hyperlinkContributors = new LinkedList<HyperlinkContributorDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.hyperlink.hyperlinkContributor");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if ("contributor".equals(e.getName())) {
                try {
                    Object instance = e.createExecutableExtension("contributor");
                    if (instance instanceof HyperlinkContributor) {
                        HyperlinkContributorDescriptor wrapper = new HyperlinkContributorDescriptor((HyperlinkContributor)instance);
                        wrapper.setId(e.getAttribute("id"));
                        wrapper.setLabel(e.getAttribute("label"));
                        wrapper.setDescription(e.getAttribute("description"));
                        wrapper.init();
                        this.hyperlinkContributors.add(wrapper);
                    }
                }
                catch (Exception ex) {
                    Activator.log.warn("Invalid hyperlink contribution from: " + String.valueOf(e.getContributor()));
                }
            }
            ++n2;
        }
    }

    @Override
    public List<HyperLinkObject> getHyperlinks(Object fromElement) {
        LinkedList<HyperLinkObject> hyperlinks = new LinkedList<HyperLinkObject>();
        HashSet<Object> addedHyperlinks = new HashSet<Object>();
        for (HyperlinkContributorDescriptor contributor : this.hyperlinkContributors) {
            if (!contributor.isActive()) continue;
            List<HyperLinkObject> hyperlinkObjects = contributor.getHyperlinks(fromElement);
            for (HyperLinkObject hyperlink : hyperlinkObjects) {
                Object target = null;
                target = hyperlink instanceof HyperLinkSpecificObject ? ((HyperLinkSpecificObject)hyperlink).getTargetElement() : hyperlink.getObject();
                if (addedHyperlinks.contains(target)) continue;
                addedHyperlinks.add(target);
                hyperlinks.add(hyperlink);
            }
        }
        return hyperlinks;
    }

    public List<HyperlinkContributorDescriptor> getHyperlinkContributors() {
        return this.hyperlinkContributors;
    }

    public static abstract class ContributorDescriptor {
        private String label;
        private String description;
        private String id;
        private final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();

        public void init() {
            String isActiveKey = ContributorDescriptor.getIsActiveKey(this);
            this.preferences.setDefault(isActiveKey, true);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isActive() {
            String preferenceKey = ContributorDescriptor.getIsActiveKey(this);
            return this.preferences.getBoolean(preferenceKey);
        }

        public static String getIsActiveKey(ContributorDescriptor strategy) {
            return strategy.getId() + ".isActive";
        }
    }

    public static class HyperlinkContributorDescriptor
    extends ContributorDescriptor
    implements HyperlinkContributor {
        private final HyperlinkContributor contributor;

        public HyperlinkContributorDescriptor(HyperlinkContributor contributor) {
            this.contributor = contributor;
        }

        @Override
        public List<HyperLinkObject> getHyperlinks(Object fromElement) {
            if (this.isActive()) {
                return this.contributor.getHyperlinks(fromElement);
            }
            return Collections.emptyList();
        }
    }
}

