/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.rulebased.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.infra.types.rulebased.Activator;
import org.eclipse.papyrus.infra.types.rulebased.AndRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.CompositeRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.NotRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.OrRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.RuleBasedTypeConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.core.RuleConfigurationTypeRegistry;

public class DefaultRuleEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        List<ConfiguredHintedSpecializationElementType> types = this.getTypes(request);
        for (ConfiguredHintedSpecializationElementType configuredHintedSpecializationElementType : types) {
            if (this.approveRequest(configuredHintedSpecializationElementType, request)) continue;
            return false;
        }
        return true;
    }

    protected List<ConfiguredHintedSpecializationElementType> getTypes(IEditCommandRequest request) {
        ArrayList<ConfiguredHintedSpecializationElementType> result = new ArrayList<ConfiguredHintedSpecializationElementType>();
        if (request instanceof CreateElementRequest) {
            IElementType typeToCreate = ((CreateElementRequest)request).getElementType();
            List<ConfiguredHintedSpecializationElementType> superConfiguredTypes = this.getAllTypes(typeToCreate);
            result.addAll(superConfiguredTypes);
        } else if (request instanceof SetRequest) {
            EStructuralFeature feature = ((SetRequest)request).getFeature();
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                Object value = ((SetRequest)request).getValue();
                ArrayList<Object> values = new ArrayList<Object>();
                if (value instanceof EObject) {
                    values.add(value);
                } else if (value instanceof List) {
                    values.addAll((List)value);
                }
                for (Object e : values) {
                    IElementType[] types;
                    if (!(e instanceof EObject)) continue;
                    IElementType[] iElementTypeArray = types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)e, request.getClientContext());
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IElementType type = iElementTypeArray[n2];
                        this.appendConfiguredTypes(type, result);
                        ++n2;
                    }
                }
            }
        } else if (request instanceof MoveRequest) {
            Map objectsToMove = ((MoveRequest)request).getElementsToMove();
            this.appendConfiguredTypes(request, objectsToMove.keySet(), result);
        } else {
            List elementsToEdit = request.getElementsToEdit();
            this.appendConfiguredTypes(request, elementsToEdit, result);
        }
        return result;
    }

    private void appendConfiguredTypes(IEditCommandRequest request, Collection<? extends EObject> objects, Collection<? super ConfiguredHintedSpecializationElementType> result) {
        objects.stream().map(object -> ElementTypeRegistry.getInstance().getAllTypesMatching(object, request.getClientContext())).flatMap(iElementTypeArray -> Stream.of(iElementTypeArray)).forEach(type -> this.appendConfiguredTypes((IElementType)type, result));
    }

    private void appendConfiguredTypes(IElementType type, Collection<? super ConfiguredHintedSpecializationElementType> result) {
        if (type instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)type).getConfiguration() instanceof RuleBasedTypeConfiguration) {
            result.add((ConfiguredHintedSpecializationElementType)((ConfiguredHintedSpecializationElementType)type));
            List<ConfiguredHintedSpecializationElementType> superConfiguredTypes = this.getAllSuperConfiguredTypes((ConfiguredHintedSpecializationElementType)type);
            result.addAll(superConfiguredTypes);
        }
    }

    protected List<ConfiguredHintedSpecializationElementType> getAllTypes(IElementType type) {
        IElementType[] superTypes;
        ArrayList<ConfiguredHintedSpecializationElementType> result = new ArrayList<ConfiguredHintedSpecializationElementType>();
        if (!(type instanceof ConfiguredHintedSpecializationElementType)) {
            return result;
        }
        if (((ConfiguredHintedSpecializationElementType)type).getConfiguration() instanceof RuleBasedTypeConfiguration) {
            result.add((ConfiguredHintedSpecializationElementType)type);
        }
        if ((superTypes = type.getAllSuperTypes()).length == 0) {
            return result;
        }
        int i = superTypes.length - 1;
        while (i >= 0) {
            if (superTypes[i] instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)superTypes[i]).getConfiguration() instanceof RuleBasedTypeConfiguration) {
                result.add((ConfiguredHintedSpecializationElementType)superTypes[i]);
            }
            --i;
        }
        return result;
    }

    protected List<ConfiguredHintedSpecializationElementType> getAllSuperConfiguredTypes(ConfiguredHintedSpecializationElementType type) {
        IElementType[] superTypes = type.getAllSuperTypes();
        if (superTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConfiguredHintedSpecializationElementType> superElementTypes = new ArrayList<ConfiguredHintedSpecializationElementType>();
        int i = superTypes.length - 1;
        while (i >= 0) {
            if (superTypes[i] instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)superTypes[i]).getConfiguration() instanceof RuleBasedTypeConfiguration) {
                superElementTypes.add((ConfiguredHintedSpecializationElementType)superTypes[i]);
            }
            --i;
        }
        return superElementTypes;
    }

    protected boolean processCompositeRule(CompositeRuleConfiguration compositeRule, IEditCommandRequest request) {
        Iterator iterator = compositeRule.getComposedRules().iterator();
        RuleConfiguration nextComposedRuleConfiguration = (RuleConfiguration)iterator.next();
        boolean result = this.processRule(nextComposedRuleConfiguration, request);
        while (iterator.hasNext()) {
            nextComposedRuleConfiguration = (RuleConfiguration)iterator.next();
            boolean resultNextComposedRuleConfiguration = this.processRule(nextComposedRuleConfiguration, request);
            if (compositeRule instanceof OrRuleConfiguration) {
                if (result || !resultNextComposedRuleConfiguration) continue;
                result = true;
                continue;
            }
            if (!(compositeRule instanceof AndRuleConfiguration) || !result || resultNextComposedRuleConfiguration) continue;
            result = false;
        }
        return result;
    }

    protected boolean processRule(RuleConfiguration ruleConfiguration, IEditCommandRequest request) {
        if (ruleConfiguration instanceof CompositeRuleConfiguration) {
            return this.processCompositeRule((CompositeRuleConfiguration)ruleConfiguration, request);
        }
        if (ruleConfiguration instanceof NotRuleConfiguration) {
            RuleConfiguration composedRule = ((NotRuleConfiguration)ruleConfiguration).getComposedRule();
            return !this.processRule(composedRule, request);
        }
        return RuleConfigurationTypeRegistry.getInstance().getRule(ruleConfiguration).approveRequest(request);
    }

    protected boolean approveRequest(ConfiguredHintedSpecializationElementType elementType, IEditCommandRequest request) {
        ElementTypeConfiguration configuration = elementType.getConfiguration();
        if (configuration instanceof RuleBasedTypeConfiguration) {
            RuleConfiguration ruleConfiguration = ((RuleBasedTypeConfiguration)configuration).getRuleConfiguration();
            return this.processRule(ruleConfiguration, request);
        }
        Activator.log.warn("Expected RuleConfiguration as configuration type for : " + String.valueOf(elementType));
        return true;
    }
}

