/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.AbstractInvocationActionPinUpdater;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class SendSignalActionPinUpdater
extends AbstractInvocationActionPinUpdater<SendSignalAction> {
    @Override
    public void updatePins(SendSignalAction node) {
        super.updatePins(node);
        InputPin targetPin = this.deriveTarget(node);
        if (node.getTarget() == null) {
            node.setTarget(targetPin);
        } else {
            SendSignalActionPinUpdater.update((Pin)node.getTarget(), (Pin)targetPin);
        }
    }

    private static boolean canReceive(Class clazz, Signal signal) {
        Reception matchingReception = null;
        Iterator receptionsIterator = clazz.getOwnedReceptions().iterator();
        while (matchingReception == null && receptionsIterator.hasNext()) {
            Reception currentReception = (Reception)receptionsIterator.next();
            if (currentReception.getSignal() == null) continue;
            Object object = matchingReception = currentReception.getSignal().conformsTo((Type)signal) ? currentReception : null;
        }
        return matchingReception != null;
    }

    private Type deriveTargetType(SendSignalAction node) {
        Class targetPinType = null;
        if (node.getOnPort() != null) {
            targetPinType = node.getOnPort().getClass_();
        } else {
            Type currentTargetPinType;
            if (node.getTarget() != null && (currentTargetPinType = node.getTarget().getType()) instanceof Class && SendSignalActionPinUpdater.canReceive((Class)currentTargetPinType, node.getSignal())) {
                targetPinType = currentTargetPinType;
            }
            if (targetPinType == null && Display.getCurrent() != null) {
                Object[] result;
                InputPin currentTargetPin = node.getTarget();
                if (currentTargetPin == null) {
                    node.setTarget(UMLFactory.eINSTANCE.createInputPin());
                }
                UMLContentProvider provider = new UMLContentProvider((EObject)node.getTarget(), (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
                TreeSelectorDialog dialog = new TreeSelectorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.setTitle("Select type");
                dialog.setDescription("Select type for target input pin");
                dialog.setContentProvider((ITreeContentProvider)provider);
                dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
                int userResponse = dialog.open();
                if (userResponse == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof Type) {
                    targetPinType = (Type)result[0];
                }
                node.setTarget(currentTargetPin);
            }
        }
        return targetPinType;
    }

    @Override
    public InputPin deriveTarget(SendSignalAction node) {
        InputPin targetPin = UMLFactory.eINSTANCE.createInputPin();
        targetPin.setLower(1);
        targetPin.setUpper(1);
        targetPin.setName("target");
        targetPin.setType(this.deriveTargetType(node));
        return targetPin;
    }

    @Override
    public List<InputPin> deriveArguments(SendSignalAction node) {
        ArrayList<InputPin> derivedInputPins = new ArrayList<InputPin>();
        if (node.getSignal() != null) {
            for (Property property : node.getSignal().getAllAttributes()) {
                InputPin derivedPin = UMLFactory.eINSTANCE.createInputPin();
                derivedInputPins.add(derivedPin);
                derivedPin.setLower(property.getLower());
                derivedPin.setUpper(property.getUpper());
                derivedPin.setType(property.getType());
                derivedPin.setName(property.getName());
                if (!InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)property) || UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)property) == null) continue;
                UMLLabelInternationalization.getInstance().setLabel((NamedElement)derivedPin, UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)property), null);
            }
        }
        return derivedInputPins;
    }
}

