/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractMissingExtensionMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.ProfileMarkerResolutionUtils;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.uml2.uml.Profile;

public class NoUMLGenPackageMarkerResolution
extends AbstractMissingExtensionMarkerResolution {
    public NoUMLGenPackageMarkerResolution() {
        super(16715845);
    }

    public String getDescription() {
        return Messages.NoUMLGenPackageMarkerResolution_description;
    }

    public String getLabel() {
        return Messages.NoUMLGenPackageMarkerResolution_label;
    }

    protected String getExtensionPoint(IMarker marker) {
        return "org.eclipse.uml2.uml.generated_package";
    }

    protected void configureExtension(IPluginExtension extension, IMarker marker) throws CoreException {
        IPluginElement packageElement = this.createElement((IPluginParent)extension, "profile");
        Optional<Profile> profileOptional = ProfileMarkerResolutionUtils.getProfile(marker);
        if (profileOptional.isEmpty()) {
            return;
        }
        Profile profile = profileOptional.get();
        String uri = ProfileMarkerResolutionUtils.getStereotypeUri(profile);
        if (uri != null) {
            packageElement.setAttribute("uri", uri);
        }
        Resource resource = profile.eResource();
        String uriFragment = resource.getURIFragment((EObject)profile);
        IFile umlModelFile = ProfileMarkerResolutionUtils.getUMLModelFile(marker);
        if (umlModelFile != null) {
            String location = ResourceUtils.mapAndEncodePath((IFile)umlModelFile) + "#" + uriFragment;
            packageElement.setAttribute("location", location);
        }
    }
}

