/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.DeltaStrategy;
import org.eclipse.papyrus.uml.profile.types.generator.ElementTypeRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.papyrus.uml.profile.types.generator.strategy.ElementTypeConfigHelper;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ConfigurationSetRule {
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private ElementTypeRule _elementTypeRule;
    @Inject
    @Extension
    private ElementTypeConfigHelper _elementTypeConfigHelper;
    @Inject
    private Optional<DeltaStrategy.Diff> diff;
    private static List<ElementTypeConfiguration> elementTypeConfigurationList;
    private final HashMap<ArrayList<?>, ElementTypeSetConfiguration> _createCache_newConfigurationSet = CollectionLiterals.newHashMap();

    public static ElementTypeConfiguration addElementType(ElementTypeConfiguration elementtype) {
        Functions.Function1 _function = el -> el.getIdentifier().equals(elementtype.getIdentifier());
        ElementTypeConfiguration found = (ElementTypeConfiguration)IterableExtensions.findFirst(elementTypeConfigurationList, (Functions.Function1)_function);
        boolean _equals = Objects.equals(found, null);
        if (_equals) {
            elementTypeConfigurationList.add(elementtype);
            return elementtype;
        }
        return found;
    }

    public ElementTypeSetConfiguration toConfigurationSet(Profile umlProfile, EList<? super EObject> originalOutput) {
        if (!Objects.equals(originalOutput, null) && !originalOutput.isEmpty()) {
            boolean _not;
            boolean _isEmpty = this.diff.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Functions.Function1 _function = it -> it instanceof ElementTypeSetConfiguration;
                Object _findFirst = IterableExtensions.findFirst(originalOutput, (Functions.Function1)_function);
                ElementTypeSetConfiguration typeSet = (ElementTypeSetConfiguration)_findFirst;
                this.updateElementTypeSet(umlProfile, typeSet, this.diff.get());
                return typeSet;
            }
            return null;
        }
        return this.newConfigurationSet(umlProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementTypeSetConfiguration newConfigurationSet(Profile umlProfile) {
        ElementTypeSetConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, ElementTypeSetConfiguration> hashMap = this._createCache_newConfigurationSet;
        synchronized (hashMap) {
            ElementTypeSetConfiguration _createElementTypeSetConfiguration;
            if (this._createCache_newConfigurationSet.containsKey(_cacheKey)) {
                return this._createCache_newConfigurationSet.get(_cacheKey);
            }
            _result = _createElementTypeSetConfiguration = elementtypesconfigurationsFactory.createElementTypeSetConfiguration();
            this._createCache_newConfigurationSet.put(_cacheKey, _result);
        }
        this._init_newConfigurationSet(_result, umlProfile);
        return _result;
    }

    private void _init_newConfigurationSet(ElementTypeSetConfiguration it, Profile umlProfile) {
        DeltaStrategy.DiffImpl newDiff = new DeltaStrategy.DiffImpl();
        Iterables.addAll(newDiff.addedStereotypes, this._uML.getAllStereotypes((Package)umlProfile));
        this._identifiers.setIdentifierBase((Package)umlProfile);
        it.setIdentifier(this._identifiers.getQualified("elementTypes"));
        this.updateElementTypeSet(umlProfile, it, newDiff);
    }

    public ElementTypeSetConfiguration updateElementTypeSet(Profile umlProfile, ElementTypeSetConfiguration typeSet, DeltaStrategy.Diff diff) {
        List<ImpliedExtension> list;
        Map<String, Stereotype> _renamedStereotypes;
        List<String> _removedStereotypes;
        List<Stereotype> _addedStereotypes;
        ElementTypeSetConfiguration _xblockexpression = null;
        ElementTypeConfigHelper helper = new ElementTypeConfigHelper();
        elementTypeConfigurationList = CollectionLiterals.newArrayList();
        this._identifiers.setIdentifierBase((Package)umlProfile);
        String _elvis = null;
        ElementTypeSetConfiguration _baseUMLElementTypeSet = this._uMLElementTypes.getBaseUMLElementTypeSet();
        String _metamodelNsURI = null;
        if (_baseUMLElementTypeSet != null) {
            _metamodelNsURI = _baseUMLElementTypeSet.getMetamodelNsURI();
        }
        _elvis = _metamodelNsURI != null ? _metamodelNsURI : "http://www.eclipse.org/uml2/5.0.0/UML";
        typeSet.setMetamodelNsURI(_elvis);
        List<Stereotype> addedStereotypes = _addedStereotypes = diff.getAddedStereotypes();
        for (Stereotype addedStereotype : addedStereotypes) {
            Iterable<ImpliedExtension> _impliedExtensions = this._uML.impliedExtensions(addedStereotype);
            for (ImpliedExtension ext : _impliedExtensions) {
                Iterable<? extends ElementTypeConfiguration> _diagramSpecificElementTypes = this._uMLElementTypes.getDiagramSpecificElementTypes(ext.getMetaclass());
                for (ElementTypeConfiguration elementTypeConfiguration : _diagramSpecificElementTypes) {
                    SpecializationTypeConfiguration elementtype = this._elementTypeRule.toElementType(ext, elementTypeConfiguration);
                    elementTypeConfigurationList.add((ElementTypeConfiguration)elementtype);
                }
            }
        }
        List<String> removedStereotypes = _removedStereotypes = diff.getRemovedStereotypes();
        Consumer<String> _function = it -> {
            if (Objects.equals(it, null) || it.isEmpty()) {
                return;
            }
            EList _elementTypeConfigurations = typeSet.getElementTypeConfigurations();
            Consumer<ElementTypeConfiguration> _function_1 = typeConfig -> {
                String _stereotypeName = this._elementTypeConfigHelper.getStereotypeName((ElementTypeConfiguration)typeConfig);
                boolean _equals = Objects.equals(_stereotypeName, it);
                if (_equals) {
                    typeSet.getElementTypeConfigurations().remove(typeConfig);
                }
            };
            new ArrayList<ElementTypeConfiguration>((Collection<ElementTypeConfiguration>)_elementTypeConfigurations).forEach(_function_1);
        };
        removedStereotypes.forEach(_function);
        Map<String, Stereotype> renamedStereotypes = _renamedStereotypes = diff.getRenamedStereotypes();
        Set<Map.Entry<String, Stereotype>> _entrySet = renamedStereotypes.entrySet();
        for (Map.Entry<String, Stereotype> entry : _entrySet) {
            String oldName = entry.getKey();
            Stereotype stereotype = entry.getValue();
            Functions.Function1 _function_1 = type -> {
                String _stereotypeName = helper.getStereotypeName((ElementTypeConfiguration)type);
                return Objects.equals(_stereotypeName, oldName);
            };
            Consumer<ElementTypeConfiguration> consumer = type -> this._elementTypeRule.setStereotypeName((ElementTypeConfiguration)type, stereotype);
            IterableExtensions.filter((Iterable)typeSet.getElementTypeConfigurations(), (Functions.Function1)_function_1).forEach(consumer);
        }
        List<ImpliedExtension> addedExtensions = list = diff.getAddedExtensions();
        for (ImpliedExtension ext_1 : addedExtensions) {
            Iterable<? extends ElementTypeConfiguration> _diagramSpecificElementTypes_1 = this._uMLElementTypes.getDiagramSpecificElementTypes(ext_1.getMetaclass());
            for (ElementTypeConfiguration elementTypeConfiguration : _diagramSpecificElementTypes_1) {
                SpecializationTypeConfiguration elementtype = this._elementTypeRule.toElementType(ext_1, elementTypeConfiguration);
                elementTypeConfigurationList.add((ElementTypeConfiguration)elementtype);
            }
        }
        Predicate<ElementTypeConfiguration> _function_1 = type -> diff.getRemovedExtensions().contains(this._elementTypeConfigHelper.getExtension((ElementTypeConfiguration)type, umlProfile));
        typeSet.getElementTypeConfigurations().removeIf(_function_1);
        Procedures.Procedure1 _function_2 = it -> {
            boolean _useDiPostfix = this._identifiers.useDiPostfix();
            if (_useDiPostfix) {
                String _name = umlProfile.getName();
                String _plus = _name + " DI";
                it.setName(_plus);
            } else {
                it.setName(umlProfile.getName());
            }
            Functions.Function1 _function_3 = it_1 -> it_1.getIdentifier();
            it.getElementTypeConfigurations().addAll((Collection)IterableExtensions.sortBy(elementTypeConfigurationList, (Functions.Function1)_function_3));
        };
        _xblockexpression = (ElementTypeSetConfiguration)ObjectExtensions.operator_doubleArrow((Object)typeSet, (Procedures.Procedure1)_function_2);
        return _xblockexpression;
    }
}

