/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.uml.controlmode.profile.helpers.ProfileApplicationHelper;
import org.eclipse.uml2.uml.Package;

public class MoveProfileApplicationCommand
extends AbstractControlCommand {
    public MoveProfileApplicationCommand(ControlModeRequest request) {
        super("Move stereotype application to new resource", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eContainer().eResource())), request);
        Assert.isLegal((boolean)(request.getTargetObject() instanceof Package));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Package packageUncontroled = (Package)this.getRequest().getTargetObject();
        Resource sourceResource = packageUncontroled.eContainer().eResource();
        Resource targetResource = this.getRequest().getTargetResource(this.getRequest().getNewURI().fileExtension());
        if (targetResource == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to retreive target resource");
        }
        ProfileApplicationHelper.nestedRelocateStereotypeApplications(packageUncontroled, sourceResource, targetResource);
        return CommandResult.newOKCommandResult();
    }
}

