/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByColumnGroupReorderDragMode;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByColumnReorderDragMode;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderPainter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.action.GroupByDragMode;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.action.ColumnGroupHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;

public class GroupByHeaderConfiguration
extends AbstractRegistryConfiguration {
    private final GroupByHeaderPainter groupByHeaderPainter;
    private ColumnGroupHeaderLayer columnGroupHeaderLayer;

    public GroupByHeaderConfiguration(GroupByModel groupByModel, IDataProvider columnHeaderDataProvider) {
        this.groupByHeaderPainter = new GroupByHeaderPainter(groupByModel, columnHeaderDataProvider);
    }

    public GroupByHeaderConfiguration(GroupByModel groupByModel, IDataProvider columnHeaderDataProvider, ColumnHeaderLayer columnHeaderLayer) {
        this.groupByHeaderPainter = new GroupByHeaderPainter(groupByModel, columnHeaderDataProvider, columnHeaderLayer);
    }

    public GroupByHeaderConfiguration(GroupByModel groupByModel, IDataProvider columnHeaderDataProvider, ColumnHeaderLayer columnHeaderLayer, ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.groupByHeaderPainter = new GroupByHeaderPainter(groupByModel, columnHeaderDataProvider, columnHeaderLayer);
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.groupByHeaderPainter, DisplayMode.NORMAL, "GROUP_BY_REGION");
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        if (this.columnGroupHeaderLayer == null) {
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), (IDragMode)new AggregateDragMode(new IDragMode[]{new CellDragMode(), new GroupByColumnReorderDragMode(), new GroupByDragMode()}));
        } else {
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), (IDragMode)new AggregateDragMode(new IDragMode[]{new CellDragMode(), new GroupByColumnGroupReorderDragMode(this.columnGroupHeaderLayer), new GroupByDragMode()}));
            uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)MouseEventMatcher.columnGroupHeaderLeftClick((int)0), (IDragMode)new AggregateDragMode(new IDragMode[]{new CellDragMode(), new ColumnGroupHeaderReorderDragMode(this.columnGroupHeaderLayer){

                public boolean isValidTargetColumnPosition(ILayer natLayer, int dragFromGridColumnPosition, int dragToGridColumnPosition) {
                    LabelStack regionLabels = natLayer.getRegionLabelsByXY(this.currentEvent.x, this.currentEvent.y);
                    if (regionLabels != null && !regionLabels.hasLabel("GROUP_BY_REGION")) {
                        return super.isValidTargetColumnPosition(natLayer, dragFromGridColumnPosition, dragToGridColumnPosition);
                    }
                    return false;
                }
            }}));
        }
    }

    public GroupByHeaderPainter getGroupByHeaderPainter() {
        return this.groupByHeaderPainter;
    }
}

