/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.strategy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.dnd.Activator;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.MultipleDropStrategy;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;

public abstract class TransactionalCommandsDropStrategy
extends TransactionalDropStrategy
implements MultipleDropStrategy {
    @Override
    protected boolean isTransactional(EditPart targetEditPart) {
        return this.getTransactionalEditingDomain(targetEditPart) != null;
    }

    @Override
    protected TransactionalEditingDomain getTransactionalEditingDomain(EditPart targetEditPart) {
        EditingDomain domain = this.getEditingDomain(targetEditPart);
        if (domain instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }

    @Override
    protected EditingDomain getEditingDomain(EditPart targetEditPart) {
        return EMFHelper.resolveEditingDomain((Object)targetEditPart);
    }

    protected abstract List<Command> doGetCommands(Request var1, EditPart var2);

    @Override
    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        List<Command> commands = this.doGetCommands(request, targetEditPart);
        if (commands != null && commands.size() > 0) {
            return commands.get(0);
        }
        return null;
    }

    @Override
    public List<Command> getCommands(Request request, EditPart targetEditPart) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (this.doGetCommands(request, targetEditPart) != null && this.doGetCommands(request, targetEditPart).size() != 0) {
            for (final Command c : this.doGetCommands(request, targetEditPart)) {
                String label = c.getLabel();
                if (label == null || "".equals(label)) {
                    label = this.getLabel();
                }
                AbstractTransactionalCommand transactionalCommand = new AbstractTransactionalCommand(this.getTransactionalEditingDomain(targetEditPart), label, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        try {
                            c.execute();
                            return CommandResult.newOKCommandResult();
                        }
                        catch (Exception ex) {
                            Activator.log.error((Throwable)ex);
                            return CommandResult.newErrorCommandResult((Throwable)ex);
                        }
                    }
                };
                commands.add((Command)new ICommandProxy((ICommand)transactionalCommand));
            }
        }
        return commands;
    }

    @Override
    public Command getCommand(Request request, EditPart targetEditPart) {
        List<Command> commands = this.doGetCommands(request, targetEditPart);
        if (commands == null || commands.size() <= 0) {
            return null;
        }
        final Command command = commands.get(0);
        if (command == null) {
            return null;
        }
        String label = command.getLabel();
        if (label == null || "".equals(label)) {
            label = this.getLabel();
        }
        AbstractTransactionalCommand transactionalCommand = new AbstractTransactionalCommand(this.getTransactionalEditingDomain(targetEditPart), label, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    command.execute();
                    return CommandResult.newOKCommandResult();
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    return CommandResult.newErrorCommandResult((Throwable)ex);
                }
            }
        };
        return new ICommandProxy((ICommand)transactionalCommand);
    }
}

