/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.StereotypePropertiesCompartment;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CustomInteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionCompartmentEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;

public class CustomInteractionEditPartTN
extends InteractionEditPartTN {
    private static final int HEADER_HEIGHT_PADDING = 4;
    private static final int MIN_HEADER_HEIGHT = 21;

    public CustomInteractionEditPartTN(View view) {
        super(view);
    }

    @Override
    protected IFigure createNodeShape() {
        final CustomInteractionRectangleFigure interactionRectangleFigure = new CustomInteractionRectangleFigure();
        interactionRectangleFigure.getCompartmentFigure().setOutline(false);
        interactionRectangleFigure.getNameLabel().setVisible(false);
        interactionRectangleFigure.setShadow(false);
        interactionRectangleFigure.setLayoutManager((LayoutManager)new AbstractLayout(){

            public void layout(IFigure container) {
                Rectangle clientArea = container.getClientArea();
                List children = container.getChildren();
                int consumedHeight = 0;
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    if (child.equals(interactionRectangleFigure.getHeaderLabelContainer())) {
                        height = Math.max(interactionRectangleFigure.getHeaderLabel().getPreferredSize().height + 4, 21);
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y + consumedHeight, clientArea.width, height));
                        consumedHeight += height;
                    } else if (child.equals(interactionRectangleFigure.getCompartmentFigure())) {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y + consumedHeight, clientArea.width, clientArea.height - 3 - consumedHeight - 30));
                    } else if (child instanceof StereotypePropertiesCompartment) {
                        height = child.getPreferredSize().height;
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y + consumedHeight, clientArea.width, height));
                        consumedHeight += height;
                    } else if (child.equals(interactionRectangleFigure.getTimeRulerContainerFigure())) {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y + clientArea.height - 30, clientArea.width, 30));
                        consumedHeight += 30;
                    } else if (i == 0 && !(child instanceof WrappingLabel)) {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y, clientArea.width, consumedHeight += child.getPreferredSize().height));
                    } else if (i == 0 && !(child instanceof WrappingLabel)) {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y, clientArea.width, consumedHeight += child.getPreferredSize().height));
                    } else {
                        child.setBounds(new Rectangle(clientArea.x, clientArea.y, 0, 0));
                    }
                    ++i;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
        this.primaryShape = interactionRectangleFigure;
        return this.primaryShape;
    }

    public Command getCommand(Request request) {
        if (request instanceof DropObjectsRequest) {
            DropObjectsRequest dropObjectsRequest = (DropObjectsRequest)request;
            EditPart compartment = EditPartUtils.findFirstChildEditPartWithId((EditPart)this, "Interaction_SubfragmentCompartment");
            if (compartment != null) {
                return compartment.getCommand((Request)dropObjectsRequest);
            }
            Activator.log.error((Throwable)new IllegalStateException("No " + InteractionCompartmentEditPartTN.class.getSimpleName() + " found in the " + CustomInteractionEditPartTN.class.getSimpleName()));
        }
        return super.getCommand(request);
    }

    @Override
    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                String visualID = UMLVisualIDRegistry.getVisualID(childView);
                if ("Gate_Shape".equals(visualID)) {
                    return new BorderItemSelectionEditPolicy();
                }
                return new NonResizableEditPolicy();
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }
}

