/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.service.types.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.GeneralizationSet;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class GeneralizationSetCreationCommand
extends CreateRelationshipCommand {
    private GeneralizationSet generalizationSettoCreate;

    public GeneralizationSetCreationCommand(CreateRelationshipRequest request) {
        super(request);
    }

    private void launchDialog(final List<GeneralizationSet> generalizationSetList, TransactionalEditingDomain editingDomain) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                final Button[] radios = new Button[2];
                Shell dialog = new Shell(display, 67680);
                dialog.setBackground(ColorConstants.white);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.verticalSpacing = 8;
                dialog.setLayout((Layout)gridLayout);
                dialog.setText(Messages.GeneralizationSetCreationCommand_0);
                Label text = new Label((Composite)dialog, 0x1000000);
                text.setText(Messages.GeneralizationSetCreationCommand_1);
                text.setBackground(ColorConstants.white);
                GridData gridData = new GridData(32);
                gridData.horizontalSpan = 1;
                text.setLayoutData((Object)gridData);
                radios[0] = new Button((Composite)dialog, 16);
                radios[0].setBackground(ColorConstants.white);
                gridData = new GridData(256);
                gridData.horizontalSpan = 1;
                radios[0].setLayoutData((Object)gridData);
                text = new Label((Composite)dialog, 0x1000000);
                text.setBackground(ColorConstants.white);
                text.setText(Messages.GeneralizationSetCreationCommand_2);
                gridData = new GridData(32);
                gridData.horizontalSpan = 1;
                text.setLayoutData((Object)gridData);
                radios[1] = new Button((Composite)dialog, 16);
                radios[1].setBackground(ColorConstants.white);
                gridData = new GridData(256);
                gridData.horizontalSpan = 1;
                radios[1].setLayoutData((Object)gridData);
                final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)dialog, 2050);
                gridData = new GridData(256);
                gridData.horizontalSpan = 2;
                list.setLayoutData((Object)gridData);
                int i = 0;
                while (i < generalizationSetList.size()) {
                    if (((GeneralizationSet)generalizationSetList.get(i)).getLabel() != null) {
                        list.add(((GeneralizationSet)generalizationSetList.get(i)).getLabel());
                    } else {
                        list.add("GeneralizationSet" + i);
                    }
                    ++i;
                }
                radios[0].addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        list.setEnabled(!radios[0].getSelection());
                    }
                });
                radios[1].setSelection(true);
                Button buttonok = new Button((Composite)dialog, 8);
                gridData = new GridData(64);
                gridData.horizontalSpan = 1;
                gridData.horizontalAlignment = 3;
                buttonok.setLayoutData((Object)gridData);
                buttonok.setText(Messages.GeneralizationSetCreationCommand_4);
                Button cancel = new Button((Composite)dialog, 8);
                gridData = new GridData(256);
                gridData.horizontalSpan = 1;
                gridData.horizontalAlignment = 3;
                cancel.setLayoutData((Object)gridData);
                cancel.setText(Messages.GeneralizationSetCreationCommand_5);
                DialogListener listener = new DialogListener(generalizationSetList, list, buttonok);
                buttonok.addListener(13, (Listener)listener);
                cancel.addListener(13, (Listener)listener);
                dialog.pack();
                dialog.open();
                while (!dialog.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                GeneralizationSetCreationCommand.this.generalizationSettoCreate = listener.getResult();
            }
        });
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Generalization source = (Generalization)this.getSource();
        Generalization target = (Generalization)this.getTarget();
        Package container = (Package)((CreateRelationshipRequest)this.getRequest()).getContainer();
        ArrayList<GeneralizationSet> generalizationSetList = new ArrayList<GeneralizationSet>((Collection<GeneralizationSet>)source.getGeneralizationSets());
        for (GeneralizationSet currentGeneralizationSet : target.getGeneralizationSets()) {
            if (generalizationSetList.contains(currentGeneralizationSet)) continue;
            generalizationSetList.add(currentGeneralizationSet);
        }
        if (generalizationSetList.size() > 0) {
            this.launchDialog(generalizationSetList, this.getEditingDomain());
        }
        if (this.generalizationSettoCreate == null) {
            this.generalizationSettoCreate = UMLFactory.eINSTANCE.createGeneralizationSet();
            this.generalizationSettoCreate.setName("GeneralizationSet_" + source.getSpecific().getName() + "_" + target.getSpecific().getName());
            container.getPackagedElements().add((Object)this.generalizationSettoCreate);
        }
        if (!this.generalizationSettoCreate.getGeneralizations().contains((Object)source)) {
            this.generalizationSettoCreate.getGeneralizations().add((Object)source);
        }
        if (!this.generalizationSettoCreate.getGeneralizations().contains((Object)target)) {
            this.generalizationSettoCreate.getGeneralizations().add((Object)target);
        }
        this.getCreateRequest().setNewElement((EObject)this.generalizationSettoCreate);
        return CommandResult.newOKCommandResult();
    }

    private class DialogListener
    implements Listener {
        private Button abuttonOk;
        private org.eclipse.swt.widgets.List acombo;
        private GeneralizationSet ageneralizationSet = null;
        private List<GeneralizationSet> ageneralizationSetList;

        public DialogListener(List<GeneralizationSet> generalizationSetList, org.eclipse.swt.widgets.List combo, Button buttonOK) {
            this.ageneralizationSetList = generalizationSetList;
            this.acombo = combo;
            this.abuttonOk = buttonOK;
        }

        public GeneralizationSet getResult() {
            return this.ageneralizationSet;
        }

        public void handleEvent(Event event) {
            if (event.widget.equals(this.abuttonOk)) {
                int selectedButtonIndex = 0;
                selectedButtonIndex = this.acombo.getSelectionIndex();
                if (selectedButtonIndex >= 0) {
                    this.ageneralizationSet = this.ageneralizationSetList.get(selectedButtonIndex);
                }
                ((Shell)this.abuttonOk.getParent()).close();
            }
        }
    }
}

