/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.profile.definition;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileRedefinition {
    public static void redefineProfile(Package thepackage, PapyrusDefinitionAnnotation definitionAnnotation) {
        if (thepackage instanceof Profile) {
            Profile profile = (Profile)thepackage;
            EPackage profileDefinition = profile.getDefinition();
            for (EClassifier eclassifier : profileDefinition.getEClassifiers()) {
                if (!(eclassifier instanceof EClass)) continue;
                ProfileRedefinition.redefineEclass((EClass)eclassifier);
            }
            if (definitionAnnotation != null) {
                profile.getDefinition().getEAnnotations().add((Object)definitionAnnotation.convertToEAnnotation());
            }
        }
        for (Package nextPackage : thepackage.getNestedPackages()) {
            ProfileRedefinition.redefineProfile(nextPackage, definitionAnnotation);
        }
    }

    public static void redefineEclass(EClass eclass) {
        if (ProfileRedefinition.isADirectDefinition(eclass)) {
            EList eSuperTypes = eclass.getESuperTypes();
            ArrayList superTypesList = new ArrayList();
            superTypesList.addAll(eSuperTypes);
            for (EClass currentSuperClass : superTypesList) {
                if (ProfileRedefinition.isADirectDefinition(currentSuperClass)) continue;
                EClass directSuperClass = (EClass)ProfileRedefinition.lookForDirectDefinitionFrom((EClassifier)currentSuperClass);
                eclass.getESuperTypes().remove((Object)currentSuperClass);
                eclass.getESuperTypes().add((Object)directSuperClass);
            }
            Iterator referencesIterator = eclass.getEReferences().iterator();
            while (referencesIterator.hasNext()) {
                ProfileRedefinition.redefineEReference((EReference)referencesIterator.next(), eclass.getEPackage());
            }
        }
    }

    public static void redefineEReference(EReference eReference, EPackage profileDefinition) {
        EReference oldEOpposite = eReference.getEOpposite();
        EClassifier oldType = eReference.getEType();
        if (oldType instanceof EClass) {
            eReference.setEType(ProfileRedefinition.lookForDirectDefinitionFrom(oldType));
            if (oldEOpposite != null) {
                eReference.setEOpposite(ProfileRedefinition.lookForEquivalentEreference((EClass)eReference.getEType(), oldEOpposite));
            }
        }
    }

    public static boolean isADirectDefinition(EClass eclass) {
        EAnnotation eAnnotation;
        if (eclass.getEAnnotations().size() > 0 && (eAnnotation = eclass.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")).getReferences().size() > 0) {
            Classifier theClassifier;
            Package nearestPackage;
            if (!(eAnnotation.getReferences().get(0) instanceof Classifier)) {
                String errMsg = "Problem because of the definition of " + eclass.getName() + " in " + eclass.getEPackage().getNsURI();
                Activator.log.error(errMsg, null);
            }
            if ((nearestPackage = (theClassifier = (Classifier)eAnnotation.getReferences().get(0)).getNearestPackage()) instanceof Profile && eclass.equals(((Profile)nearestPackage).getDefinition((NamedElement)theClassifier))) {
                return true;
            }
        }
        return false;
    }

    public static EClassifier lookForDirectDefinitionFrom(EClassifier eClassifier) {
        EAnnotation eAnnotation;
        if (eClassifier.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eClassifier.getEAnnotations().get(0)).getReferences().size() > 0) {
            Classifier theClassifier = (Classifier)eAnnotation.getReferences().get(0);
            Package nearestPackage = theClassifier.getNearestPackage();
            if (nearestPackage instanceof Profile) {
                return (EClassifier)((Profile)nearestPackage).getDefinition((NamedElement)theClassifier);
            }
            return eClassifier;
        }
        return eClassifier;
    }

    private static EReference lookForEquivalentEreference(EClass eclass, EReference eReference) {
        for (EReference currentEReference : eclass.getEReferences()) {
            if (!currentEReference.getName().equals(eReference.getName()) || !currentEReference.getEType().getName().endsWith(eReference.getEType().getName())) continue;
            return currentEReference;
        }
        return null;
    }

    public static void cleanProfile(Package thePackage) {
        if (thePackage instanceof Profile) {
            Profile profile = (Profile)thePackage;
            EPackage profileDefinition = profile.getDefinition();
            ArrayList<EClassifier> tempList = new ArrayList<EClassifier>();
            int i = 0;
            while (i < profileDefinition.getEClassifiers().size()) {
                tempList.add((EClassifier)profileDefinition.getEClassifiers().get(i));
                ++i;
            }
            for (EClassifier eclassifier : tempList) {
                if (!(eclassifier instanceof EClass) || ProfileRedefinition.isADirectDefinition((EClass)eclassifier)) continue;
                profileDefinition.getEClassifiers().remove((Object)eclassifier);
            }
        }
        for (Package p : thePackage.getNestedPackages()) {
            ProfileRedefinition.cleanProfile(p);
        }
    }

    public static EAttribute createEAttribute(EClass container, EReference eReference) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setEType(eReference.getEType());
        eAttribute.setName(eReference.getName());
        eAttribute.setChangeable(eReference.isChangeable());
        eAttribute.setLowerBound(eReference.getLowerBound());
        eAttribute.setUpperBound(eReference.getUpperBound());
        eAttribute.setOrdered(eReference.isOrdered());
        eAttribute.setDerived(eReference.isDerived());
        eAttribute.setTransient(eReference.isTransient());
        eAttribute.setUnique(eReference.isUnique());
        eAttribute.setUnsettable(eReference.isUnsettable());
        eAttribute.setVolatile(eReference.isVolatile());
        container.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    public static Classifier getUMLClassifierFromDefinition(EClassifier eclass) {
        EAnnotation eAnnotation;
        if (eclass.getEAnnotations().size() > 0 && (eAnnotation = (EAnnotation)eclass.getEAnnotations().get(0)).getReferences().size() > 0) {
            Classifier theClassifier = (Classifier)eAnnotation.getReferences().get(0);
            return theClassifier;
        }
        return null;
    }

    public static void removeUndefinedVersion(Package packageElement) {
        PapyrusDefinitionAnnotation tagVersion;
        EAnnotation firstAnnotation;
        EAnnotation umlAnnotation;
        if (packageElement instanceof Profile && (umlAnnotation = ((Profile)packageElement).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (firstAnnotation = umlAnnotation.getEAnnotation("PapyrusVersion")) != null && PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION.equals(tagVersion = PapyrusDefinitionAnnotation.parseEAnnotation(firstAnnotation))) {
            umlAnnotation.getEAnnotations().remove((Object)firstAnnotation);
        }
    }
}

