/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.convert;

import java.text.ParseException;
import org.eclipse.nebula.widgets.nattable.data.convert.NumericDisplayConverter;

public class DefaultIntegerDisplayConverter
extends NumericDisplayConverter {
    public DefaultIntegerDisplayConverter() {
        this(true);
    }

    public DefaultIntegerDisplayConverter(boolean useNumberFormat) {
        if (!useNumberFormat) {
            this.nf = null;
        }
    }

    @Override
    protected Object convertToNumericValue(String value) {
        if (this.nf != null) {
            try {
                return this.nf.parse(value).intValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getLocalizedMessage());
            }
        }
        return Integer.valueOf(value);
    }
}

