/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFactory;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.RepresentationKindRule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ArchitectureViewpointRule {
    @Extension
    private static ArchitectureFactory factory = ArchitectureFactory.eINSTANCE;
    @Inject
    @Extension
    private ArchitectureExtensions _architectureExtensions;
    @Inject
    @Extension
    private RepresentationKindRule _representationKindRule;
    private final HashMap<ArrayList<?>, ArchitectureViewpoint> _createCache_mergedViewpoint = CollectionLiterals.newHashMap();

    public ArchitectureViewpoint mergedViewpoint(String name, Set<? extends ArchitectureContext> contexts) {
        return this.mergedViewpoint(name, contexts, this._architectureExtensions.currentScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchitectureViewpoint mergedViewpoint(String name, Set<? extends ArchitectureContext> contexts, Object scope) {
        ArchitectureViewpoint _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{name, contexts, scope});
        HashMap<ArrayList<?>, ArchitectureViewpoint> hashMap = this._createCache_mergedViewpoint;
        synchronized (hashMap) {
            ArchitectureViewpoint _createArchitectureViewpoint;
            if (this._createCache_mergedViewpoint.containsKey(_cacheKey)) {
                return this._createCache_mergedViewpoint.get(_cacheKey);
            }
            _result = _createArchitectureViewpoint = factory.createArchitectureViewpoint();
            this._createCache_mergedViewpoint.put(_cacheKey, _result);
        }
        this._init_mergedViewpoint(_result, name, contexts, scope);
        return _result;
    }

    private void _init_mergedViewpoint(ArchitectureViewpoint result, String name, Set<? extends ArchitectureContext> contexts, Object scope) {
        Functions.Function1 _function = it -> it.getViewpoints();
        Consumer<ArchitectureViewpoint> _function_1 = viewpoint -> {
            ArchitectureViewpoint _copy = this._architectureExtensions.copy(result, viewpoint);
            Procedures.Procedure1 _function_2 = it -> {
                EList _concerns = it.getConcerns();
                Functions.Function1 _function_3 = it_1 -> it_1.getName();
                Functions.Function1 _function_4 = it_1 -> this._architectureExtensions.mergedConcern((String)it_1);
                Iterable _map = IterableExtensions.map(this._architectureExtensions.mapUnique(viewpoint.getConcerns(), _function_3), (Functions.Function1)_function_4);
                Iterables.addAll((Collection)_concerns, (Iterable)_map);
                EList _representationKinds = it.getRepresentationKinds();
                Functions.Function1 _function_5 = it_1 -> this._representationKindRule.merged((RepresentationKind)it_1);
                List _map_1 = ListExtensions.map((List)viewpoint.getRepresentationKinds(), (Functions.Function1)_function_5);
                Iterables.addAll((Collection)_representationKinds, (Iterable)_map_1);
            };
            ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function_2);
            ArchitectureExtensions.logf("Merged %s into %s", viewpoint, result);
        };
        this._architectureExtensions.named(IterableExtensions.flatMap(contexts, (Functions.Function1)_function), name).forEach(_function_1);
    }
}

