/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal;

import java.util.ArrayList;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.ext.widgets.reference.internal.EEFExtReferenceController;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.properties.common.dialog.PropertiesUtils;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EditableReferenceController
extends EEFExtReferenceController {
    private IEEFLifecycleManager lifecycleManager;
    private PropertiesUtils propertiesUtils;
    private boolean isEnabled;

    public EditableReferenceController(IEEFLifecycleManager lifecycleManager, EEFExtEditableReferenceDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter, boolean isEnabled) {
        super((EEFExtReferenceDescription)description, variableManager, interpreter, editingContextAdapter);
        this.lifecycleManager = lifecycleManager;
        this.propertiesUtils = new PropertiesUtils();
        this.isEnabled = isEnabled;
    }

    protected EEFExtEditableReferenceDescription getDescription() {
        return (EEFExtEditableReferenceDescription)super.getDescription();
    }

    public String getOnClickExpression() {
        return this.getDescription().getOnClickExpression();
    }

    public String getCreateExpression() {
        return this.getDescription().getCreateExpression();
    }

    public String getRemoveExpression() {
        return this.getDescription().getRemoveExpression();
    }

    public String getBrowseExpression() {
        return this.getDescription().getBrowseExpression();
    }

    public void onClick(Object element, String onClickEventKind) {
        if ("DOUBLE_CLICK".equals(onClickEventKind) && this.isEnabled) {
            this.editingContextAdapter.performModelChange(() -> {
                int returnCode;
                EObject target = null;
                if (element instanceof EObject) {
                    target = (EObject)element;
                } else if (element instanceof ArrayList && !((ArrayList)element).isEmpty()) {
                    target = (EObject)((ArrayList)element).get(0);
                }
                if (target != null && (returnCode = this.getPropertiesUtils().displayEditionProperties(this.editingContextAdapter, target, this.variableManager, this.interpreter)) == 0) {
                    this.lifecycleManager.refresh();
                }
            });
        }
    }

    public PropertiesUtils getPropertiesUtils() {
        return this.propertiesUtils;
    }
}

