/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.ExtendedPluginPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.IPaletteDescription;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationPackage;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;

public class LocalExtendedPaletteProvider
extends ExtendedPluginPaletteProvider
implements IPaletteProvider {
    protected boolean loadResourceExceptionLogged = false;

    public void setContributions(IPaletteDescription description) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Object paletteContributions = description.getContributions();
        this.contributions = Collections.emptyList();
        if (paletteContributions instanceof String) {
            Resource resource = null;
            IPath resourcePath = Activator.getInstance().getStateLocation().append((String)description.getContributions());
            URI uri = URI.createFileURI((String)resourcePath.toOSString());
            if (uri != null && uri.isFile()) {
                resource = resourceSet.createResource(uri);
            }
            if (resource != null) {
                try {
                    resource.load(Collections.emptyMap());
                    if (!resource.getContents().isEmpty()) {
                        this.deployLocalElementTypeModels(description.getPaletteID());
                        this.contributions = new ArrayList(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)PaletteconfigurationPackage.eINSTANCE.getPaletteConfiguration()));
                    }
                }
                catch (IOException e) {
                    if (!this.loadResourceExceptionLogged) {
                        Activator.log.debug(Messages.LocalExtendedPaletteProvider_Error_ImpossibleToLoadRessource + String.valueOf(description));
                        this.loadResourceExceptionLogged = true;
                    }
                    this.contributions = Collections.emptyList();
                }
            }
        }
    }

    private void deployLocalElementTypeModels(String paletteID) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        StringBuilder stringBuilderUI = new StringBuilder();
        stringBuilderUI.append(paletteID);
        stringBuilderUI.append("_UI.elementtypesconfigurations");
        File fileUI = Activator.getInstance().getStateLocation().append(stringBuilderUI.toString()).toFile();
        StringBuilder stringBuilderSem = new StringBuilder();
        stringBuilderSem.append(paletteID);
        stringBuilderSem.append("_Semantic.elementtypesconfigurations");
        File fileSem = Activator.getInstance().getStateLocation().append(stringBuilderSem.toString()).toFile();
        if (fileSem.canRead() && fileUI.canRead()) {
            URI elementTypeUIURI = URI.createFileURI((String)fileUI.getAbsolutePath());
            URI elementTypeSemURI = URI.createFileURI((String)fileSem.getAbsolutePath());
            if (elementTypeUIURI != null && elementTypeSemURI != null) {
                Resource elementTypeUIResource = resourceSet.createResource(elementTypeUIURI);
                Resource elementTypeSemResource = resourceSet.createResource(elementTypeSemURI);
                try {
                    elementTypeUIResource.load(Collections.emptyMap());
                    elementTypeSemResource.load(Collections.emptyMap());
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                if (!elementTypeUIResource.getContents().isEmpty() && !elementTypeSemResource.getContents().isEmpty()) {
                    String clientContext = "org.eclipse.papyrus.infra.services.edit.TypeContext";
                    ElementTypeSetConfigurationRegistry.getInstance().unload(clientContext, ((ElementTypeSetConfiguration)elementTypeSemResource.getContents().get(0)).getIdentifier());
                    ElementTypeSetConfigurationRegistry.getInstance().unload(clientContext, ((ElementTypeSetConfiguration)elementTypeUIResource.getContents().get(0)).getIdentifier());
                    ElementTypeSetConfigurationRegistry.getInstance().loadElementTypeSetConfiguration(clientContext, (ElementTypeSetConfiguration)elementTypeSemResource.getContents().get(0));
                    ElementTypeSetConfigurationRegistry.getInstance().loadElementTypeSetConfiguration(clientContext, (ElementTypeSetConfiguration)elementTypeUIResource.getContents().get(0));
                }
            }
        }
    }
}

