/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.ContentHelper;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;

public class AddElementToDiagramServices {
    public static final AddElementToDiagramServices INSTANCE = new AddElementToDiagramServices();

    private AddElementToDiagramServices() {
    }

    public List<DiagramElementMapping> getValidMappingsForDiagram(EObject semanticElement, DSemanticDiagram diagram, Session session) {
        ArrayList<DiagramElementMapping> mappings = new ArrayList<DiagramElementMapping>();
        if (!this.isValidForDiagram((DDiagram)diagram, null).apply((Object)semanticElement)) {
            return mappings;
        }
        ModelAccessor modelAccessor = session.getModelAccessor();
        for (DiagramElementMapping mapping : this.getDiagramMappings(diagram)) {
            String domainClass = null;
            if (mapping instanceof AbstractNodeMapping) {
                domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
            } else if (mapping instanceof EdgeMapping) {
                domainClass = ((EdgeMapping)mapping).getDomainClass();
            }
            if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || diagram.isSynchronized()) continue;
            mappings.add(mapping);
        }
        return mappings;
    }

    private Set<DiagramElementMapping> getDiagramMappings(DSemanticDiagram diagram) {
        DiagramDescription desc = diagram.getDescription();
        HashSet<DiagramElementMapping> diagMappings = new HashSet<DiagramElementMapping>();
        diagMappings.addAll((Collection<DiagramElementMapping>)ContentHelper.getAllContainerMappings((DiagramDescription)desc, (boolean)false));
        diagMappings.addAll((Collection<DiagramElementMapping>)ContentHelper.getAllNodeMappings((DiagramDescription)desc, (boolean)false));
        diagMappings.addAll((Collection<DiagramElementMapping>)ContentHelper.getAllEdgeMappings((DiagramDescription)desc, (boolean)false));
        return diagMappings;
    }

    private Predicate<Object> getValidsForClassDiagram() {
        Predicate<Object> validForClassDiagram = new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Package || input instanceof Interface || input instanceof DataType || "Class".equals(((EObject)input).eClass().getName()) || "Component".equals(((EObject)input).eClass().getName());
            }
        };
        return validForClassDiagram;
    }

    public Predicate<Object> isValidForDiagram(DDiagram diagram, EObject container) {
        DiagramDescription description;
        Predicate<Object> results = Predicates.alwaysTrue();
        if (diagram instanceof DSemanticDiagram && ("Class Diagram".equals((description = ((DSemanticDiagram)diagram).getDescription()).getName()) || "Profile Diagram".equals(description.getName()))) {
            results = this.getValidsForClassDiagram();
        }
        return results;
    }
}

