/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;

public class ProjectUtil {
    public static final String CUSTOM_PROJECT_NAME = "org.eclipse.papyrus.views.properties.toolsmiths.internal";

    public static IFile getContextFile(Context context) throws CoreException {
        IFolder projectFolder = ProjectUtil.getContextFolder(context);
        IFile contextFile = projectFolder.getFile(context.getName() + ".ctx");
        return contextFile;
    }

    public static IProject getContextProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject custom = workspace.getRoot().getProject(CUSTOM_PROJECT_NAME);
        if (!custom.exists()) {
            IProjectDescription description = workspace.newProjectDescription(CUSTOM_PROJECT_NAME);
            IPath customProjectPath = Activator.getDefault().getPreferencesPath().append("/org.eclipse.papyrus.views.properties.toolsmiths.internal");
            description.setLocation(customProjectPath);
            custom.create(description, null);
            custom.open(null);
        }
        if (!custom.isOpen()) {
            custom.open(null);
        }
        custom.setHidden(true);
        workspace.getRoot().refreshLocal(2, null);
        return custom;
    }

    public static IFolder getContextFolder(Context context) throws CoreException {
        IProject project = ProjectUtil.getContextProject();
        IFolder projectFolder = project.getFolder(context.getName());
        if (!projectFolder.exists()) {
            String referencedFolderPath = new File(context.eResource().getURI().toFileString()).getParent();
            projectFolder.createLink((IPath)new Path(referencedFolderPath), 256, null);
        }
        return projectFolder;
    }

    public static IFile getSectionFile(Section section) throws CoreException {
        IFolder projectFolder = ProjectUtil.getContextFolder((Context)section.eContainer().eContainer());
        IFile sectionFile = projectFolder.getFile(section.getSectionFile());
        return sectionFile;
    }
}

