/**
 * Copyright (c) 2007, 2014, 2021 Borland Software Corporation, Christian W. Damus, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Christian W. Damus - bug 451230
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up + The reverse var seems to be inverted for 'contains' call
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.OclMigrationProblems_qvto;
import xpt.QualifiedClassNameProvider;
import xpt.diagram.Utils_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.expressions.getExpression;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class BaseItemSemanticEditPolicy {
  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private VisualIDRegistry _visualIDRegistry;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private OclMigrationProblems_qvto _oclMigrationProblems_qvto;

  @Inject
  @Extension
  private xpt.diagram.editpolicies.Utils_qvto _utils_qvto_1;

  @Inject
  @Extension
  private QualifiedClassNameProvider _qualifiedClassNameProvider;

  @Inject
  private Activator xptPluginActivator;

  @Inject
  private MetaModel xptMetaModel;

  @Inject
  private getExpression xptGetExpression;

  @Inject
  private ElementTypes xptElementTypes;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _baseItemSemanticEditPolicyClassName = it.getBaseItemSemanticEditPolicyClassName();
    _builder.append(_baseItemSemanticEditPolicyClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getDiagram().getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence BaseItemSemanticEditPolicy(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractBaseItemSemanticEditPolicy {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected String getVisualIdFromView(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _visualIDMethodCall = this._visualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _semanticPart = this.semanticPart(it);
    _builder.append(_semanticPart, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<GenLink, Boolean> _function = (GenLink link) -> {
        boolean _isSansDomain = link.isSansDomain();
        return Boolean.valueOf((!_isSansDomain));
      };
      boolean _exists = IterableExtensions.<GenLink>exists(it.getLinks(), _function);
      if (_exists) {
        _builder.append("\t");
        CharSequence _linkConstraints = this.linkConstraints(it);
        _builder.append(_linkConstraints, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(elementType);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence semanticPart(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _contextElementType = this.getContextElementType(it);
    _builder.append(_contextElementType);
    _builder.append("\t\t");
    _builder.newLineIfNotEmpty();
    CharSequence _createRelationshipCommand = this.getCreateRelationshipCommand(it);
    _builder.append(_createRelationshipCommand);
    _builder.append("\t\t");
    _builder.newLineIfNotEmpty();
    CharSequence _createSemanticServiceEditCommand = this.getCreateSemanticServiceEditCommand(it);
    _builder.append(_createSemanticServiceEditCommand);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence getContextElementType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.emf.type.core.IElementType getContextElementType(org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType requestContextElementType = ");
    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getElementType(getVisualID(request));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return requestContextElementType != null ? requestContextElementType : getBaseElementType();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getCreateRelationshipCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isUsingElementTypeCreationCommand = it.isUsingElementTypeCreationCommand();
      if (_isUsingElementTypeCreationCommand) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gef.commands.Command getCreateRelationshipCommand(org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest req) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.papyrus.infra.services.edit.service.IElementEditService commandService = org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils.getCommandProvider(((org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart)getHost()).resolveSemanticElement());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(req.getElementType() != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("commandService = org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils.getCommandProvider(req.getElementType(), req.getClientContext());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(commandService == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand semanticCommand = commandService.getEditCommand(req);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if((semanticCommand != null) && (semanticCommand.canExecute())) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return getGEFWrapper(semanticCommand);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  /**
   * FIXME need to check constraint's provider to ensure we don't generate a field
   * 		for e.g. Java (or Literal, which is unlikely, though) expressions
   * 
   * 		[Papyrus Quick Fix] Do not generate field when the expression is provided
   * 		by a GenJavaExpressionProvider.
   */
  public CharSequence linkConstraints(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static ");
    String _linkCreationConstraintsClassName = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName);
    _builder.append(" getLinkConstraints() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _linkCreationConstraintsClassName_1 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_1, "\t");
    _builder.append(" cached = ");
    CharSequence _instanceAccess = this.xptPluginActivator.instanceAccess(it.getEditorGen());
    _builder.append(_instanceAccess, "\t");
    _builder.append(".getLinkConstraints();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (cached == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _instanceAccess_1 = this.xptPluginActivator.instanceAccess(it.getEditorGen());
    _builder.append(_instanceAccess_1, "\t\t");
    _builder.append(".setLinkConstraints(cached = new ");
    String _linkCreationConstraintsClassName_2 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_2, "\t\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return cached;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static class ");
    String _linkCreationConstraintsClassName_3 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_3);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    String _linkCreationConstraintsClassName_4 = it.getLinkCreationConstraintsClassName();
    _builder.append(_linkCreationConstraintsClassName_4, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// use static method #getLinkConstraints() to access instance");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink nextLink : _links) {
        _builder.append("\t");
        CharSequence _canCreate = this.canCreate(nextLink);
        _builder.append(_canCreate, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      EList<GenLink> _links_1 = it.getLinks();
      for(final GenLink nextLink_1 : _links_1) {
        _builder.append("\t");
        CharSequence _canExist = this.canExist(nextLink_1);
        _builder.append(_canExist, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence canCreate(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canCreate");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("(");
    {
      boolean _isSansDomain = it.isSansDomain();
      boolean _not = (!_isSansDomain);
      if (_not) {
        CharSequence _canCreateParameters = this.canCreateParameters(it.getModelFacet());
        _builder.append(_canCreateParameters);
      }
    }
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    {
      boolean _isSansDomain_1 = it.isSansDomain();
      boolean _not_1 = (!_isSansDomain_1);
      if (_not_1) {
        _builder.append("\t");
        CharSequence _checkEMFConstraints = this.checkEMFConstraints(it.getModelFacet());
        _builder.append(_checkEMFConstraints, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("return canExist");
    String _stringUniqueIdentifier_1 = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier_1, "\t");
    _builder.append("(");
    {
      boolean _isSansDomain_2 = it.isSansDomain();
      boolean _not_2 = (!_isSansDomain_2);
      if (_not_2) {
        CharSequence _canCreateValues = this.canCreateValues(it.getModelFacet());
        _builder.append(_canCreateValues, "\t");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * XXX for now, both constraints are injected into single method
   * 		which may not be suitable for modification especially when mixing
   * 		java and ocl constraints (former requires manual code).
   * 	Better approach would be:
   * 		if either is non-null and providers are not the same - introduce two methods,
   * 		to check source and target separately. Otherwize, do it inplace.
   */
  public CharSequence canExist(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean canExist");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("(");
    {
      boolean _isSansDomain = it.isSansDomain();
      boolean _not = (!_isSansDomain);
      if (_not) {
        CharSequence _canExistParameters = this.canExistParameters(it.getModelFacet());
        _builder.append(_canExistParameters);
      }
    }
    _builder.append("\t) {");
    _builder.newLineIfNotEmpty();
    {
      if ((((it.getCreationConstraints() != null) && it.getCreationConstraints().isValid()) && (it.getDiagram().getEditorGen().getExpressionProviders() != null))) {
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        {
          GenConstraint _sourceEnd = it.getCreationConstraints().getSourceEnd();
          boolean _tripleNotEquals = (_sourceEnd != null);
          if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _checkAdditionalConstraint = this.checkAdditionalConstraint(it.getCreationConstraints().getSourceEnd().getProvider(), it.getCreationConstraints().getSourceEnd(), "source", "target", it.getCreationConstraints().getSourceEndContextClass(), it.getCreationConstraints().getTargetEndContextClass());
            _builder.append(_checkAdditionalConstraint, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          GenConstraint _targetEnd = it.getCreationConstraints().getTargetEnd();
          boolean _tripleNotEquals_1 = (_targetEnd != null);
          if (_tripleNotEquals_1) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _checkAdditionalConstraint_1 = this.checkAdditionalConstraint(it.getCreationConstraints().getTargetEnd().getProvider(), it.getCreationConstraints().getTargetEnd(), "target", "source", it.getCreationConstraints().getTargetEndContextClass(), it.getCreationConstraints().getSourceEndContextClass());
            _builder.append(_checkAdditionalConstraint_1, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch(Exception e) {\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _instanceAccess = this.xptPluginActivator.instanceAccess(it.getDiagram().getEditorGen());
        _builder.append(_instanceAccess, "\t\t");
        _builder.append(".logError(\"Link constraint evaluation error\", e); ");
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append(_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * FIXME XXX mark as private (_) and move to impl::<find proper place>::LinkConstraints.xpt
   */
  protected CharSequence _canCreateParameters(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }

  protected CharSequence _canCreateParameters(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName);
        _builder.append(" container, ");
      }
    }
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }

  protected CharSequence _canExistParameters(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }

  protected CharSequence _canExistParameters(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getContainmentMetaFeature().getGenClass());
        _builder.append(_QualifiedClassName);
        _builder.append(" container, ");
      }
    }
    CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getMetaClass());
    _builder.append(_QualifiedClassName_1);
    _builder.append(" linkInstance, ");
    CharSequence _sourceTargetParameters = this.sourceTargetParameters(it);
    _builder.append(_sourceTargetParameters);
    return _builder;
  }

  public CharSequence sourceTargetParameters(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" source, ");
    CharSequence _QualifiedClassName_1 = this.xptMetaModel.QualifiedClassName(it.getTargetType());
    _builder.append(_QualifiedClassName_1);
    _builder.append(" target");
    return _builder;
  }

  protected CharSequence _canCreateValues(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("source, target");
    return _builder;
  }

  protected CharSequence _canCreateValues(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
      if (_hasContainerOtherThanSource) {
        _builder.append("container, ");
      }
    }
    _builder.append("null, source, target");
    return _builder;
  }

  protected CharSequence _checkEMFConstraints(final LinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unrecognized link model facet in checkEMFConstraints: " + it));
    return _builder;
  }

  /**
   * [MG] extracted from LET statement, @see checkEMFConstraints(TypeLinkModelFacet)
   */
  private boolean checkChildFeatureBounds(final TypeLinkModelFacet it) {
    return ((!Objects.equals(it.getChildMetaFeature(), it.getContainmentMetaFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getChildMetaFeature().getEcoreFeature())));
  }

  protected CharSequence _checkEMFConstraints(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EStructuralFeature _ecoreFeature = it.getContainmentMetaFeature().getEcoreFeature();
      boolean _tripleNotEquals = (_ecoreFeature != null);
      if (_tripleNotEquals) {
        {
          if (((!this._oclMigrationProblems_qvto.isUnbounded(it.getContainmentMetaFeature().getEcoreFeature())) || this.checkChildFeatureBounds(it))) {
            _builder.append("if (");
            String _containerVariable = this._utils_qvto_1.getContainerVariable(it);
            _builder.append(_containerVariable);
            _builder.append(" != null) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _checkEMFConstraints = this.checkEMFConstraints(it.getContainmentMetaFeature(), it);
            _builder.append(_checkEMFConstraints, "\t");
            _builder.newLineIfNotEmpty();
            {
              boolean _checkChildFeatureBounds = this.checkChildFeatureBounds(it);
              if (_checkChildFeatureBounds) {
                _builder.append("\t");
                CharSequence _checkEMFConstraints_1 = this.checkEMFConstraints(it.getChildMetaFeature(), it);
                _builder.append(_checkEMFConstraints_1, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence checkEMFConstraints(final GenFeature it, final TypeLinkModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EStructuralFeature _ecoreFeature = modelFacet.getContainmentMetaFeature().getEcoreFeature();
      boolean _tripleNotEquals = (_ecoreFeature != null);
      if (_tripleNotEquals) {
        {
          boolean _isUnbounded = this._oclMigrationProblems_qvto.isUnbounded(it.getEcoreFeature());
          boolean _not = (!_isUnbounded);
          if (_not) {
            _builder.append("if (");
            CharSequence _featureBoundComparator = this.featureBoundComparator(it, this._utils_qvto_1.getContainerVariable(modelFacet), modelFacet.getSourceType());
            _builder.append(_featureBoundComparator);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  protected CharSequence _checkEMFConstraints(final FeatureLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (source != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _featureBoundsConditionClause = this.featureBoundsConditionClause(it.getMetaFeature(), "source", "target", it.getSourceType());
    _builder.append(_featureBoundsConditionClause, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      boolean _isContains = it.getMetaFeature().isContains();
      if (_isContains) {
        _builder.append("if (source == target) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    {
      GenFeature _reverse = it.getMetaFeature().getReverse();
      boolean _tripleNotEquals = (_reverse != null);
      if (_tripleNotEquals) {
        _builder.append("if (target != null && (");
        CharSequence _featureBoundsConditionClause_1 = this.featureBoundsConditionClause(it.getMetaFeature().getReverse(), "target", "source", it.getTargetType());
        _builder.append(_featureBoundsConditionClause_1);
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence featureBoundsConditionClause(final GenFeature it, final String targetVar, final String reverseVar, final GenClass targetType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EStructuralFeature _ecoreFeature = it.getEcoreFeature();
      boolean _tripleNotEquals = (_ecoreFeature != null);
      if (_tripleNotEquals) {
        {
          boolean _isUnbounded = this._oclMigrationProblems_qvto.isUnbounded(it.getEcoreFeature());
          boolean _not = (!_isUnbounded);
          if (_not) {
            CharSequence _featureBoundComparator = this.featureBoundComparator(it, targetVar, targetType);
            _builder.append(_featureBoundComparator);
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        {
          if (((!this._oclMigrationProblems_qvto.isSingleValued(it.getEcoreFeature())) && (!this._oclMigrationProblems_qvto.isUnbounded(it.getEcoreFeature())))) {
            _builder.append(" || ");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        {
          boolean _isSingleValued = this._oclMigrationProblems_qvto.isSingleValued(it.getEcoreFeature());
          boolean _not_1 = (!_isSingleValued);
          if (_not_1) {
            CharSequence _featureUniquenessComparator = this.featureUniquenessComparator(it, targetVar, reverseVar, targetType);
            _builder.append(_featureUniquenessComparator, "\t\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence featureBoundComparator(final GenFeature it, final String featureVar, final GenClass featureVarGenClass) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it, featureVar, featureVarGenClass);
    _builder.append(_featureValue);
    _builder.newLineIfNotEmpty();
    {
      int _upperBound = it.getEcoreFeature().getUpperBound();
      boolean _equals = (_upperBound == 1);
      if (_equals) {
        _builder.append("!= null");
        _builder.newLine();
      } else {
        _builder.append(".size() >= ");
        int _upperBound_1 = it.getEcoreFeature().getUpperBound();
        _builder.append(_upperBound_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence featureUniquenessComparator(final GenFeature it, final String featureVar, final String reverseVar, final GenClass featureVarGenClass) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it, featureVar, featureVarGenClass);
    _builder.append(_featureValue);
    _builder.append(".contains(");
    _builder.append(reverseVar);
    _builder.append(")");
    return _builder;
  }

  protected CharSequence _checkAdditionalConstraint(final GenExpressionProviderBase it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Have no idea what extra constraints to check for " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _checkAdditionalConstraint(final GenExpressionInterpreter it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    _builder.append(sourceEndVar);
    _builder.append(" == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.Map<String, org.eclipse.emf.ecore.EClassifier> env = java.util.Collections.<String, org.eclipse.emf.ecore.EClassifier>singletonMap(");
    CharSequence _oppositeEndVariableNameValue = this.oppositeEndVariableNameValue(it);
    _builder.append(_oppositeEndVariableNameValue, "\t");
    _builder.append(", ");
    CharSequence _MetaClass = this.xptMetaModel.MetaClass(oppositeEndContext);
    _builder.append(_MetaClass, "\t");
    _builder.append("); ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Object ");
    _builder.append(sourceEndVar, "\t");
    _builder.append("Val = ");
    CharSequence _expression = this.xptGetExpression.getExpression(it, valueExpr, context, "env");
    _builder.append(_expression, "\t");
    _builder.append(".evaluate(");
    _builder.append(sourceEndVar, "\t");
    _builder.append(", java.util.Collections.singletonMap(");
    CharSequence _oppositeEndVariableNameValue_1 = this.oppositeEndVariableNameValue(it);
    _builder.append(_oppositeEndVariableNameValue_1, "\t");
    _builder.append(", ");
    _builder.append(targetEndVar, "\t");
    _builder.append(")); ");
    CharSequence _nonNLS_1 = this._common.nonNLS();
    _builder.append(_nonNLS_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (false == ");
    _builder.append(sourceEndVar, "\t");
    _builder.append("Val instanceof Boolean || !((Boolean) ");
    _builder.append(sourceEndVar, "\t");
    _builder.append("Val).booleanValue()) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} // else fall-through");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _checkAdditionalConstraint(final GenJavaExpressionProvider it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((it.isInjectExpressionBody() && (valueExpr.getBody() != null)) && (!valueExpr.getBody().isEmpty()))) {
        String _body = valueExpr.getBody();
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && ((valueExpr.getBody() == null) || valueExpr.getBody().isEmpty())))) {
          _builder.append("// TODO: implement this method, using ");
          _builder.append(sourceEndVar);
          _builder.append(" and ");
          _builder.append(targetEndVar);
          _builder.append(" ");
          _builder.newLineIfNotEmpty();
          _builder.append("// to access link source and target, respectively");
          _builder.newLine();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("if (Boolean.TRUE.booleanValue()) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No java implementation provided\"); ");
          CharSequence _nonNLS = this._common.nonNLS();
          _builder.append(_nonNLS, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        } else {
          _builder.append("if (Boolean.TRUE.booleanValue()) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return false;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      }
    }
    return _builder;
  }

  @MetaDef
  public CharSequence canExistCall(final FeatureLinkModelFacet xptSelf, final GenLink link, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canExist");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }

  /**
   * NOTE, containerVar will be used only when link has other container than its source. It's safe to pass variable/method name that doesn't exist
   */
  @MetaDef
  public CharSequence canExistCall(final TypeLinkModelFacet xptSelf, final GenLink link, final String containerVar, final String linkVar, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canExist");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(xptSelf);
      if (_hasContainerOtherThanSource) {
        _builder.append(containerVar);
        _builder.append(", ");
      }
    }
    _builder.append(linkVar);
    _builder.append(", ");
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }

  @MetaDef
  public CharSequence canCreateCall(final FeatureLinkModelFacet xptSelf, final GenLink link, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canCreate");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }

  /**
   * NOTE, containerVar will be used only when link has other container than its source. It's safe to pass variable/method name that doesn't exist
   * Yes, this is sorta hack, but no idea of better approach right now. Perhaps, CreateLinkUtils may always define getContainer() for TypeLinkModelFacet, and use getSource() by default?
   */
  @MetaDef
  public CharSequence canCreateCall(final TypeLinkModelFacet xptSelf, final GenLink link, final String containerVar, final String sourceVar, final String targetVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence __accessLinkConstraints = this._accessLinkConstraints(link.getDiagram());
    _builder.append(__accessLinkConstraints);
    _builder.append(".canCreate");
    String _uniqueIdentifier = link.getUniqueIdentifier();
    _builder.append(_uniqueIdentifier);
    _builder.append("(");
    {
      boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(xptSelf);
      if (_hasContainerOtherThanSource) {
        _builder.append(containerVar);
        _builder.append(", ");
      }
    }
    _builder.append(sourceVar);
    _builder.append(", ");
    _builder.append(targetVar);
    _builder.append(")");
    return _builder;
  }

  @MetaDef
  private CharSequence _accessLinkConstraints(final GenDiagram xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(xptSelf);
    _builder.append(_qualifiedClassName);
    _builder.append(".getLinkConstraints()");
    return _builder;
  }

  public CharSequence oppositeEndVariableNameValue(final Object any) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\"oppositeEnd\"");
    return _builder;
  }

  public CharSequence defaultConstructor(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _itemSemanticEditPolicyClassName = this._qualifiedClassNameProvider.getItemSemanticEditPolicyClassName(it);
    _builder.append(_itemSemanticEditPolicyClassName);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _defaultConstructorBody = this.defaultConstructorBody(it);
    _builder.append(_defaultConstructorBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * @param genCommon diagram, node or link, which MUST have an element type (genCommon.elementType != null)
   */
  public CharSequence defaultConstructorBody(final GenCommonBase genCommon) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ElementType _elementType = genCommon.getElementType();
      boolean _tripleEquals = (_elementType == null);
      if (_tripleEquals) {
        this._common_qvto.ERROR(("No element type in the passed node. Only diagram, node or link are supported in this template: " + genCommon));
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("super(");
    CharSequence _accessElementType = this.xptElementTypes.accessElementType(genCommon);
    _builder.append(_accessElementType);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * Generate generic method if using semantic creation command based on element types framework.
   */
  public CharSequence getCreateSemanticServiceEditCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isUsingElementTypeCreationCommand = it.isUsingElementTypeCreationCommand();
      if (_isUsingElementTypeCreationCommand) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.common.core.command.ICommand getSemanticCreationCommand(org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest req) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.papyrus.infra.services.edit.service.IElementEditService commandService = org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils.getCommandProvider(req.getContainer());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(commandService == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand.INSTANCE;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return commandService.getEditCommand(req);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  @XbaseGenerated
  public CharSequence canCreateParameters(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _canCreateParameters((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _canCreateParameters(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence canExistParameters(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _canExistParameters((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _canExistParameters(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence canCreateValues(final LinkModelFacet it) {
    if (it instanceof TypeLinkModelFacet) {
      return _canCreateValues((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _canCreateValues(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkEMFConstraints(final LinkModelFacet it) {
    if (it instanceof FeatureLinkModelFacet) {
      return _checkEMFConstraints((FeatureLinkModelFacet)it);
    } else if (it instanceof TypeLinkModelFacet) {
      return _checkEMFConstraints((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _checkEMFConstraints(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public CharSequence checkAdditionalConstraint(final GenExpressionProviderBase it, final ValueExpression valueExpr, final String sourceEndVar, final String targetEndVar, final GenClass context, final GenClass oppositeEndContext) {
    if (it instanceof GenExpressionInterpreter) {
      return _checkAdditionalConstraint((GenExpressionInterpreter)it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _checkAdditionalConstraint((GenJavaExpressionProvider)it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext);
    } else if (it != null) {
      return _checkAdditionalConstraint(it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, valueExpr, sourceEndVar, targetEndVar, context, oppositeEndContext).toString());
    }
  }
}
