/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.modelelements;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.LanguagesObservableProperty;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.PrivateLayoutValue;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.RestoreActivePageValue;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;

public class WelcomeModelElement
extends EMFModelElement {
    private final String PRIVATE_LAYOUT = "privateLayout";
    private final String RESTORE_ACTIVE_PAGE = "restoreActivePage";
    private final String LANGUAGES = "languages";

    public WelcomeModelElement(EObject source, EditingDomain domain) {
        super(source, domain);
    }

    protected IObservable doGetObservable(String propertyPath) {
        return switch (propertyPath) {
            case "privateLayout" -> new PrivateLayoutValue(this);
            case "restoreActivePage" -> new RestoreActivePageValue(this);
            case "languages" -> new LanguagesObservableProperty(this).get();
            default -> super.doGetObservable(propertyPath);
        };
    }

    protected boolean isFeatureEditable(String propertyPath) {
        return switch (propertyPath) {
            case "privateLayout" -> true;
            case "restoreActivePage" -> {
                IObservableValue privateLayout = (IObservableValue)this.getObservable("privateLayout");
                yield Boolean.TRUE.equals(privateLayout.getValue());
            }
            case "languages" -> true;
            default -> super.isFeatureEditable(propertyPath);
        };
    }

    protected boolean isElementEditable() {
        return true;
    }

    public boolean forceRefresh(String propertyPath) {
        return switch (propertyPath) {
            case "restoreActivePage" -> true;
            default -> super.forceRefresh(propertyPath);
        };
    }
}

