/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.editparts;

import org.eclipse.draw2d.Connection;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ConnectionLineSegEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.TreeConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ForestRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;

public abstract class OverridableConnectionNodeEditPart
extends ConnectionNodeEditPart {
    public OverridableConnectionNodeEditPart(View view) {
        super(view);
    }

    protected void installBendpointEditPolicy() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ForestRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new TreeConnectionBendpointEditPolicy());
        } else if (this.getConnectionFigure().getConnectionRouter() instanceof OrthogonalRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionLineSegEditPolicy());
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionBendpointEditPolicy());
        }
        this.refreshConnectionCursor();
    }

    protected void refreshConnectionCursor() {
        EditPartUtil.synchronizeRunnableToMainThread((IGraphicalEditPart)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (OverridableConnectionNodeEditPart.this.getConnectionFigure().getConnectionRouter() instanceof ForestRouter) {
                    OverridableConnectionNodeEditPart.this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_MOVE);
                } else if (OverridableConnectionNodeEditPart.this.getConnectionFigure().getConnectionRouter() instanceof OrthogonalRouter) {
                    OverridableConnectionNodeEditPart.this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_MOVE);
                } else {
                    OverridableConnectionNodeEditPart.this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_ADD);
                }
            }
        });
    }

    protected void refreshRouterChange() {
        this.refreshBendpoints();
        this.installBendpointEditPolicy();
    }

    protected void refreshRoutingStyles() {
        Connection connection = this.getConnectionFigure();
        if (!(connection instanceof PolylineConnectionEx)) {
            return;
        }
        PolylineConnectionEx poly = (PolylineConnectionEx)connection;
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null) {
            boolean closestDistance = style.isClosestDistance();
            boolean avoidObstruction = style.isAvoidObstructions();
            poly.setRoutingStyles(closestDistance, avoidObstruction);
            if (avoidObstruction) {
                this.installEditPolicy("Connection Bendpoint Policy", null);
            } else {
                this.installBendpointEditPolicy();
            }
        }
    }
}

