/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.fonts.internal.addon;

import java.io.IOException;
import java.net.URL;
import javax.annotation.PostConstruct;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.ui.fonts.Activator;
import org.eclipse.swt.widgets.Display;

public class FontAddon {
    @PostConstruct
    public void loadFonts() {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(this::loadFonts);
            return;
        }
        this.loadFonts(new String[]{"roboto/Roboto-Regular.ttf", "roboto/Roboto-Italic.ttf", "roboto/Roboto-Bold.ttf", "roboto/Roboto-BoldItalic.ttf"});
    }

    private void loadFonts(String[] fonts) {
        try {
            URL fontFolder = new URL("platform:/plugin/org.eclipse.papyrus.infra.ui.fonts/fonts/");
            String[] stringArray = fonts;
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String font = stringArray[n2];
                URL fontURL = new URL(fontFolder, font);
                URL fontFileURL = FileLocator.toFileURL((URL)fontURL);
                if (fontFileURL == null) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.infra.ui.fonts", "Unable to find font " + String.valueOf(fontURL)));
                } else {
                    Path path = new Path(fontFileURL.getFile());
                    String osPath = path.toOSString();
                    if (!Display.getCurrent().loadFont(osPath)) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.infra.ui.fonts", "Failed to load font " + String.valueOf(fontURL) + " (Resolved URL: " + osPath + ")"));
                    }
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.infra.ui.fonts", "Failed to load default fonts", (Throwable)ex));
            return;
        }
    }
}

