/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import com.google.common.collect.ListMultimap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PluginCheckerBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers.ProfilePluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.StaticProfileHelper;
import org.eclipse.uml2.uml.Profile;
import org.osgi.service.component.annotations.Component;

@Component
public class ProfileBuilderProvider
implements IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind builderKind) {
        return "org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic";
    }

    public boolean providesBuilder(PapyrusBuilderKind builderKind, URI resourceURI) {
        String fileName = resourceURI.lastSegment();
        int firstDot = fileName.indexOf(46);
        return fileName.substring(firstDot + 1).equals(resourceURI.fileExtension());
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind builderKind, IProject project) {
        PluginCheckerBuilder result = null;
        switch (builderKind) {
            case MODEL_RESOURCE: {
                result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", this::mapProfilesWithStereotypes).withChecker(ProfilePluginChecker.modelValidationCheckerFactory()).withChecker(ProfilePluginChecker.customModelCheckerFactory());
                break;
            }
            case BUNDLE_MANIFEST: {
                result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", this::mapProfilesResources).withChecker(ProfilePluginChecker.modelDependenciesCheckerFactory()).withChecker(ProfilePluginChecker.buildPropertiesCheckerFactory());
                break;
            }
            case PLUGIN_MANIFEST: {
                result = new PluginCheckerBuilder("org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", this::mapAllProfilesResources).withChecker(ProfilePluginChecker.extensionsCheckerFactory());
                break;
            }
        }
        return result;
    }

    private ListMultimap<IFile, EObject> mapProfilesWithStereotypes(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(StaticProfileHelper.umlWithGenmodel(), ModelResourceMapper.resourceSets(), ModelResourceMapper.rootsOfType(EObject.class));
    }

    private ListMultimap<IFile, Profile> mapProfilesResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(StaticProfileHelper.umlWithGenmodel(), ModelResourceMapper.resourceSets(), ModelResourceMapper.rootsOfType(Profile.class));
    }

    private ListMultimap<IFile, Profile> mapAllProfilesResources(IProject project) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)project);
        return mapper.map(StaticProfileHelper.umlWithGenmodel(), ModelResourceMapper.resourceSets(), ModelResourceMapper.allElementsOfType(Profile.class));
    }
}

