/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.view.services.edit.request.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.dev.view.services.edit.request.messages.Messages;
import org.eclipse.papyrus.emf.facet.common.ui.internal.views.AbstractTreeView;
import org.eclipse.swt.widgets.Composite;

public class RequestView
extends AbstractTreeView {
    private final List<IEditCommandRequest> requestList;
    private final Map<IEditCommandRequest, String> dates;
    public static RequestView INSTANCE = null;

    public RequestView() {
        INSTANCE = this;
        this.requestList = new ArrayList<IEditCommandRequest>();
        this.dates = new HashMap<IEditCommandRequest, String>();
    }

    protected void createColumns() {
        this.createNameRequestColumn();
        this.createTimeColumn();
    }

    public void addRequest(IEditCommandRequest request) {
        if (!this.requestList.contains(request)) {
            this.requestList.add(request);
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            this.dates.put(request, dateFormat.format(cal.getTime()));
            this.refresh(true);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)new Action(){

            public void run() {
                RequestView.this.clear();
                RequestView.this.refresh(true);
            }

            public boolean isEnabled() {
                return true;
            }

            public String getToolTipText() {
                return this.getText();
            }

            public String getText() {
                return Messages.RequestView_ClearTheView;
            }
        });
    }

    protected void createNameRequestColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEditCommandRequest) {
                    return element.getClass().getSimpleName();
                }
                if (element instanceof AbstractOperation) {
                    return ((AbstractOperation)element).getLabel();
                }
                if (element instanceof AbstractCommand) {
                    return ((AbstractCommand)element).getLabel();
                }
                return "no managed";
            }
        };
        this.createColumn(Messages.RequestView_Name, "NAME_COLUMN_ID", 200, columnLabelProvider);
    }

    protected void createTimeColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (RequestView.this.dates.containsKey(element)) {
                    return RequestView.this.dates.get(element);
                }
                return "";
            }
        };
        this.createColumn(Messages.RequestView_Time, "TIME_COLUMN_ID", 100, columnLabelProvider);
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        };
    }

    protected void openElement(Object element) {
    }

    protected String getRefreshMessage() {
        return "Refresh Requests View";
    }

    protected Object getInput() {
        return this.requestList;
    }

    public void dispose() {
        super.dispose();
        this.clear();
        INSTANCE = null;
    }

    private void clear() {
        this.requestList.clear();
        this.dates.clear();
    }
}

