/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Michael Golubev (Montages) - initial API and implementation
 *   Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *   Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.plugin;

import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class options {
  public CharSequence qualifiedClassName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(".options");
    return _builder;
  }

  public CharSequence fullPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence options(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("# Tracing options for the ");
    String _iD = it.getID();
    _builder.append(_iD);
    _builder.append(" plug-in");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# Common issues");
    _builder.newLine();
    String _iD_1 = it.getID();
    _builder.append(_iD_1);
    _builder.append("/debug=false");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# Visual IDs");
    _builder.newLine();
    String _iD_2 = it.getID();
    _builder.append(_iD_2);
    _builder.append("/debug/visualID=false");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
