/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositeforview;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayCommandExecution;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.stereotype.edition.provider.DisplayedProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.AppliedStereotypeDisplayComposite;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.IViewComposite;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.ProfileElementWithDisplayContentProvider;
import org.eclipse.papyrus.uml.tools.listeners.StereotypeElementListener;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppearanceForAppliedStereotypeComposite
extends AppliedStereotypeDisplayComposite
implements IViewComposite {
    private static final String STEREOTYPE_DISPLAY_TOOLTIP = "Display selected stereotype for the element in the diagram";
    private static final String STEREOTYPE_QN_DISPLAY_TOOLTIP = "Display selected stereotypes with their qualified name for the element in the diagram";
    private static final String STEREOTYPE_DISPLAY_NON_GRAPHICAL_TOOLTIP = "Stereotypes can only be displayed for elements with graphical representation. Currently edited element is a non graphical element. (example: an element selected in the outline is not a graphical element)";
    protected DisplayedProfileElementLabelProvider displayedProfileElementLabelProvider = new DisplayedProfileElementLabelProvider();
    protected StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    protected StereotypeDisplayCommandExecution commandhelper = StereotypeDisplayCommandExecution.getInstance();
    protected EModelElement diagramElement = null;
    protected Button displayButton;
    protected Button displayButtonQN;
    protected MouseListener displayButtonListener;
    protected ISelection selection;
    private Adapter elementListener;

    public AppearanceForAppliedStereotypeComposite(Composite parent) {
        super(parent);
        this.setBackground(JFaceColors.getBannerBackground((Display)parent.getDisplay()));
        this.displayButtonListener = new DisplayButtonListener();
    }

    @Override
    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.displayButton = factory.createButton((Composite)this, "", 8);
        this.displayButton.setVisible(true);
        this.displayButton.setImage(ImageManager.IMG_DISPLAY);
        this.displayButton.setToolTipText(STEREOTYPE_DISPLAY_TOOLTIP);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -5);
        this.displayButton.setLayoutData((Object)data);
        this.displayButton.addMouseListener(this.displayButtonListener);
        this.displayButtonQN = factory.createButton((Composite)this, "", 8);
        this.displayButtonQN.setVisible(true);
        this.displayButtonQN.setImage(ImageManager.IMG_CONSOLEVIEW_WITH_QN);
        this.displayButtonQN.setToolTipText(STEREOTYPE_QN_DISPLAY_TOOLTIP);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.displayButton, -5);
        this.displayButtonQN.setLayoutData((Object)data);
        this.displayButtonQN.addMouseListener(this.displayButtonListener);
        this.label = factory.createCLabel((Composite)this, this.name + ":", 0);
        this.label.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)this.displayButtonQN, -35);
        data.top = new FormAttachment(0, 0);
        this.label.setLayoutData((Object)data);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.displayedProfileElementLabelProvider);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayout((Layout)new FormLayout());
        this.tree.setVisible(true);
        data = new FormData(-1, 50);
        data.top = new FormAttachment((Control)this.displayButton, 4);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -4);
        this.tree.setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementWithDisplayContentProvider(this.diagramElement));
        this.refresh();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AppearanceForAppliedStereotypeComposite.this.refreshButtons();
            }
        });
        return this;
    }

    @Override
    public boolean isReadOnly() {
        EModelElement element = this.getDiagramElement();
        return element == null || EMFHelper.isReadOnly((EObject)element);
    }

    private void refreshButtons() {
        boolean enabled;
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        boolean bl = enabled = this.getDiagramElement() != null && !this.treeViewer.getSelection().isEmpty() && !this.isReadOnly();
        if (this.displayButton != null && !this.displayButton.isDisposed()) {
            this.displayButton.setEnabled(enabled);
        }
        if (this.displayButtonQN != null && !this.displayButtonQN.isDisposed()) {
            this.displayButtonQN.setEnabled(enabled);
        }
    }

    public void displayButtonPressed(boolean withQualifiedName) {
        if (this.getTree().getSelection().length < 1) {
            return;
        }
        if (this.getDiagramElement() == null) {
            return;
        }
        TreeItem[] treeSelection = this.getTree().getSelection();
        int i = 0;
        while (i < treeSelection.length) {
            if (treeSelection[i].getData() instanceof AppliedStereotypeTreeObject) {
                Stereotype stereo = ((AppliedStereotypeTreeObject)treeSelection[i].getData()).getStereotype();
                if (treeSelection[i].getImage().equals((Object)ImageManager.IMG_STEREOTYPE)) {
                    this.displayStereotypeLabel(stereo);
                    if (withQualifiedName) {
                        this.commandhelper.setDepth(this.getDomain(), stereo, (View)this.diagramElement, "full", true);
                        treeSelection[i].setImage(ImageManager.DISPLAYED_STEREOTYPE_QN);
                    } else {
                        this.commandhelper.setDepth(this.getDomain(), stereo, (View)this.diagramElement, "none", true);
                        treeSelection[i].setImage(ImageManager.IMG_STEREOTYPEDISPLAYED);
                    }
                } else {
                    this.hideStereotypeLabel(stereo);
                    treeSelection[i].setImage(ImageManager.IMG_STEREOTYPE);
                }
            } else if (treeSelection[i].getData() instanceof AppliedStereotypePropertyTreeObject) {
                Property property = ((AppliedStereotypePropertyTreeObject)treeSelection[i].getData()).getProperty();
                Stereotype stereotype = ((AppliedStereotypePropertyTreeObject)treeSelection[i].getData()).getStereotype();
                if (treeSelection[i].getImage().equals((Object)ImageManager.IMG_DISPLAYEDPROPERTY)) {
                    this.hideStereotypeProperty(stereotype, property);
                    treeSelection[i].setImage(ImageManager.IMG_PROPERTY);
                } else {
                    this.displayStereotypeProperty(stereotype, property);
                    treeSelection[i].setImage(ImageManager.IMG_DISPLAYEDPROPERTY);
                }
            }
            ++i;
        }
    }

    public void disposeListeners() {
        if (this.displayButton != null && !this.displayButton.isDisposed()) {
            this.displayButton.removeMouseListener(this.displayButtonListener);
        }
    }

    public EModelElement getDiagramElement() {
        return this.diagramElement;
    }

    public TransactionalEditingDomain getDomain() {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)this.element);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    @Override
    public Element getSelected() {
        Object input = ((IStructuredSelection)this.selection).getFirstElement();
        return UMLUtil.resolveUMLElement((Object)input);
    }

    @Override
    public void refresh() {
        if (this.diagramElement != null) {
            this.displayedProfileElementLabelProvider.setMainView((View)this.diagramElement);
        }
        super.refresh();
        if (this.diagramElement == null && !this.displayButton.isDisposed()) {
            this.displayButton.setToolTipText(STEREOTYPE_DISPLAY_NON_GRAPHICAL_TOOLTIP);
        } else if (!this.displayButton.isDisposed()) {
            this.displayButton.setToolTipText(STEREOTYPE_DISPLAY_TOOLTIP);
        }
        this.refreshButtons();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        if (event == null) {
            return;
        }
    }

    @Override
    public void setDiagramElement(EModelElement diagramElement) {
        this.diagramElement = diagramElement;
        ((ProfileElementWithDisplayContentProvider)this.treeViewer.getContentProvider()).setDiagramElement(diagramElement);
    }

    @Override
    public void setElement(Element element) {
        if (this.getElement() != null && this.elementListener != null) {
            this.getElement().eAdapters().remove((Object)this.elementListener);
        }
        super.setElement(element);
        if (element != null) {
            if (this.elementListener == null) {
                this.elementListener = new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        AppearanceForAppliedStereotypeComposite.this.handleNotifyChanged(msg);
                    }
                };
            }
            element.eAdapters().add((Object)this.elementListener);
        }
    }

    protected void handleNotifyChanged(Notification msg) {
        int eventType = msg.getEventType();
        if (msg instanceof StereotypeElementListener.StereotypeExtensionNotification && (eventType == 31 || eventType == 32)) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AppearanceForAppliedStereotypeComposite.this.tree != null && !AppearanceForAppliedStereotypeComposite.this.tree.isDisposed() && AppearanceForAppliedStereotypeComposite.this.treeViewer != null && AppearanceForAppliedStereotypeComposite.this.getElement() != null) {
                        AppearanceForAppliedStereotypeComposite.this.treeViewer.setInput((Object)new StereotypedElementTreeObject(AppearanceForAppliedStereotypeComposite.this.getElement()));
                    }
                    AppearanceForAppliedStereotypeComposite.this.refresh();
                }
            });
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected void displayStereotypeProperty(Stereotype stereotype, Property propertyToDisplay) {
        if (this.diagramElement != null) {
            try {
                DecorationNode nodeToDisplay = StereotypeDisplayUtil.getInstance().getStereotypeProperty((View)this.diagramElement, stereotype, propertyToDisplay);
                BasicCompartment compartment = this.helper.getStereotypeCompartment((View)this.diagramElement, stereotype);
                if (nodeToDisplay == null) {
                    nodeToDisplay = StereotypeDisplayUtil.getInstance().getStereotypePropertyInBrace((View)this.diagramElement, stereotype, propertyToDisplay);
                }
                if (compartment == null) {
                    compartment = this.helper.getStereotypeBraceCompartment((View)this.diagramElement, stereotype);
                }
                if (compartment != null && nodeToDisplay != null) {
                    this.commandhelper.setPersistency(this.getDomain(), (View)nodeToDisplay, true);
                    this.commandhelper.setVisibility(this.getDomain(), (View)nodeToDisplay, true, true);
                    if (!compartment.isVisible()) {
                        this.commandhelper.setPersistency(this.getDomain(), (View)compartment, true);
                        this.commandhelper.setVisibility(this.getDomain(), (View)compartment, true, true);
                        this.hideOtherProperties((View)compartment, (View)nodeToDisplay);
                    }
                }
            }
            catch (Exception e) {
                Activator.logException((Exception)e);
            }
        }
    }

    protected void hideStereotypeProperty(Stereotype stereotype, Property propertyToHide) {
        if (this.diagramElement != null) {
            try {
                if (stereotype != null && propertyToHide != null) {
                    DecorationNode nodeToDisplay = StereotypeDisplayUtil.getInstance().getStereotypeProperty((View)this.diagramElement, stereotype, propertyToHide);
                    BasicCompartment compartment = this.helper.getStereotypeCompartment((View)this.diagramElement, stereotype);
                    if (nodeToDisplay == null) {
                        nodeToDisplay = StereotypeDisplayUtil.getInstance().getStereotypePropertyInBrace((View)this.diagramElement, stereotype, propertyToHide);
                    }
                    if (compartment == null) {
                        compartment = this.helper.getStereotypeBraceCompartment((View)this.diagramElement, stereotype);
                    }
                    if (compartment != null && nodeToDisplay != null) {
                        this.commandhelper.setPersistency(this.getDomain(), (View)nodeToDisplay, true);
                        this.commandhelper.setVisibility(this.getDomain(), (View)nodeToDisplay, false, true);
                        this.updateCompartmentVisibility((View)compartment);
                    }
                }
            }
            catch (Exception e) {
                Activator.logException((Exception)e);
            }
        }
    }

    protected void displayStereotypeLabel(Stereotype stereotype) {
        if (this.diagramElement != null) {
            try {
                DecorationNode nodeToDisplay = this.helper.getStereotypeLabel((View)this.diagramElement, stereotype);
                if (nodeToDisplay != null) {
                    this.commandhelper.setPersistency(this.getDomain(), (View)nodeToDisplay, true);
                    this.commandhelper.setVisibility(this.getDomain(), (View)nodeToDisplay, true, true);
                }
            }
            catch (Exception e) {
                Activator.logException((Exception)e);
            }
        }
    }

    protected void hideStereotypeLabel(Stereotype stereotype) {
        if (this.diagramElement != null) {
            try {
                DecorationNode nodeToDisplay = this.helper.getStereotypeLabel((View)this.diagramElement, stereotype);
                this.commandhelper.setPersistency(this.getDomain(), (View)nodeToDisplay, true);
                this.commandhelper.setVisibility(this.getDomain(), (View)nodeToDisplay, false, true);
            }
            catch (Exception e) {
                Activator.logException((Exception)e);
            }
        }
    }

    private void updateCompartmentVisibility(View stereotypeCompartment) {
        boolean display = stereotypeCompartment.isVisible();
        if (this.helper.hasVisibleProperties(stereotypeCompartment) != display) {
            this.commandhelper.setPersistency(this.getDomain(), stereotypeCompartment, true);
            this.commandhelper.setVisibility(this.getDomain(), stereotypeCompartment, this.helper.hasVisibleProperties(stereotypeCompartment), true);
        }
    }

    private void hideOtherProperties(View compartment, View propertyToDisplay) {
        for (Object child : compartment.getChildren()) {
            if (!this.helper.isStereotypeProperty(child) && !this.helper.isStereotypeBraceProperty(child) || propertyToDisplay == child) continue;
            this.commandhelper.setVisibility(this.getDomain(), (View)child, false, true);
        }
    }

    private class DisplayButtonListener
    implements MouseListener {
        private DisplayButtonListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            boolean withQualifiedName = false;
            if (e.getSource().equals(AppearanceForAppliedStereotypeComposite.this.displayButtonQN)) {
                withQualifiedName = true;
            }
            TreeItem[] selectedTreeItems = AppearanceForAppliedStereotypeComposite.this.getTree().getSelection();
            AppearanceForAppliedStereotypeComposite.this.displayButtonPressed(withQualifiedName);
            if (!AppearanceForAppliedStereotypeComposite.this.getTree().isDisposed()) {
                AppearanceForAppliedStereotypeComposite.this.getTree().setSelection(selectedTreeItems);
            }
        }
    }
}

