/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableLabelEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;

public class ExternalLabelPrimaryDragRoleEditPolicy
extends NonResizableLabelEditPolicy {
    private Polyline tether = null;

    protected List<MoveHandle> createSelectionHandles() {
        MoveHandle mh = new MoveHandle(this.getHost());
        mh.setBorder(null);
        return Collections.singletonList(mh);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        LabelEditPart editPart = (LabelEditPart)this.getHost();
        Rectangle updatedRect = new Rectangle();
        PrecisionRectangle initialRect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        updatedRect = initialRect.getTranslated(this.getHostFigure().getParent().getBounds().getLocation().getNegated());
        double zoomLevel = DiagramEditPartsUtil.getDiagramZoomLevel((EditPart)editPart);
        updatedRect = updatedRect.getTranslated(request.getMoveDelta().scale(1.0 / zoomLevel));
        if (editPart instanceof PapyrusLabelEditPart) {
            switch (((PapyrusLabelEditPart)editPart).getTextAlignment()) {
                case 1: {
                    break;
                }
                case 2: {
                    updatedRect.translate(this.getHostFigure().getBounds().width / 2, 0);
                    break;
                }
                case 4: {
                    updatedRect.translate(this.getHostFigure().getBounds().width, 0);
                    break;
                }
            }
        }
        SetBoundsCommand moveCommand = new SetBoundsCommand(editPart.getEditingDomain(), DiagramUIMessages.MoveLabelCommand_Label_Location, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), updatedRect);
        return new ICommandProxy((ICommand)moveCommand);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            IFigure feedback = this.getDragSourceFeedbackFigure();
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            this.getHostFigure().translateToAbsolute((Translatable)realLocation);
            feedback.translateToRelative((Translatable)realLocation);
            feedback.setBounds(realLocation);
        }
        this.drawTether(request);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure feedback = super.createDragSourceFeedbackFigure();
        this.tether = new Polyline();
        this.tether.setLineStyle(2);
        this.tether.setForegroundColor(((IGraphicalEditPart)this.getHost()).getFigure().getForegroundColor());
        this.addFeedback((IFigure)this.tether);
        return feedback;
    }

    private void drawTether(ChangeBoundsRequest request) {
        IFigure p = this.getDragSourceFeedbackFigure();
        Point refPoint = ((LabelEditPart)this.getHost()).getReferencePoint();
        Rectangle centerMain = null;
        if (((IGraphicalEditPart)this.getHost().getParent()).getFigure() instanceof Connection) {
            centerMain = new Rectangle(refPoint.x, refPoint.y, 0, 0);
            this.getHostFigure().translateToAbsolute((Translatable)centerMain);
            p.translateToRelative((Translatable)centerMain);
        } else {
            centerMain = ((IGraphicalEditPart)this.getHost().getParent()).getFigure().getBounds().getCopy();
            this.getHostFigure().translateToAbsolute((Translatable)centerMain);
            centerMain.translate(centerMain.width / 2, centerMain.height / 2);
            p.translateToRelative((Translatable)centerMain);
        }
        PrecisionRectangle ref = new PrecisionRectangle(centerMain);
        Rectangle r = p.getBounds();
        Point midTop = new Point(r.x + r.width / 2, r.y);
        Point midBottom = new Point(r.x + r.width / 2, r.y + r.height);
        Point midLeft = new Point(r.x, r.y + r.height / 2);
        Point midRight = new Point(r.x + r.width, r.y + r.height / 2);
        Point startPoint = midTop;
        int x = r.x + r.width / 2 - refPoint.x;
        int y = r.y + r.height / 2 - refPoint.y;
        startPoint = y > 0 && y > x && y > -x ? midTop : (y < 0 && y < x && y < -x ? midBottom : (x < 0 && y > x && y < -x ? midRight : midLeft));
        this.tether.setStart(startPoint);
        this.tether.setEnd(ref.getLocation());
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.tether != null) {
            this.removeFeedback((IFigure)this.tether);
        }
        this.tether = null;
    }
}

