/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;

public class FillingConfigurationUtils {
    private static final String INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE = "Invert axis not yet managed -> probably impossible with tree table";

    private FillingConfigurationUtils() {
    }

    public static final List<TreeFillingConfiguration> getTreeFillingConfiguration(Table table, AxisManagerRepresentation representedAxisManager) {
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        ArrayList<TreeFillingConfiguration> confs = new ArrayList<TreeFillingConfiguration>();
        LocalTableHeaderAxisConfiguration local = table.getLocalRowHeaderAxisConfiguration();
        if (local != null && local.getAxisManagerConfigurations().size() > 0) {
            for (AxisManagerConfiguration currentRep : local.getAxisManagerConfigurations()) {
                if (currentRep.getAxisManager() != representedAxisManager) continue;
                for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                    if (!(current instanceof TreeFillingConfiguration)) continue;
                    confs.add((TreeFillingConfiguration)current);
                }
                return confs;
            }
        } else {
            for (IAxisConfiguration current : representedAxisManager.getSpecificAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration)) continue;
                confs.add((TreeFillingConfiguration)current);
            }
        }
        return confs;
    }

    public static final List<TreeFillingConfiguration> getTreeFillingConfigurationForColumn(Table table, AxisManagerRepresentation representedAxisManager) {
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        ArrayList<TreeFillingConfiguration> confs = new ArrayList<TreeFillingConfiguration>();
        LocalTableHeaderAxisConfiguration local = table.getLocalColumnHeaderAxisConfiguration();
        if (local != null && local.getAxisManagerConfigurations().size() > 0) {
            for (AxisManagerConfiguration currentRep : local.getAxisManagerConfigurations()) {
                if (currentRep.getAxisManager() != representedAxisManager) continue;
                for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                    if (!(current instanceof TreeFillingConfiguration)) continue;
                    confs.add((TreeFillingConfiguration)current);
                }
                return confs;
            }
        } else {
            for (IAxisConfiguration current : representedAxisManager.getSpecificAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration)) continue;
                confs.add((TreeFillingConfiguration)current);
            }
        }
        return confs;
    }

    public static final List<TreeFillingConfiguration> getAllTreeFillingConfigurationForDepth(Table table, int wantedDepth) {
        Iterator iterator;
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        ArrayList<TreeFillingConfiguration> confs = new ArrayList<TreeFillingConfiguration>();
        LocalTableHeaderAxisConfiguration local = table.getLocalRowHeaderAxisConfiguration();
        if (local != null && local.getAxisManagerConfigurations().size() > 0 && (iterator = local.getAxisManagerConfigurations().iterator()).hasNext()) {
            AxisManagerConfiguration currentRep = (AxisManagerConfiguration)iterator.next();
            for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != wantedDepth) continue;
                confs.add((TreeFillingConfiguration)current);
            }
            return confs;
        }
        TableHeaderAxisConfiguration rowConfig = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        EList axisManagers = rowConfig.getAxisManagers();
        for (AxisManagerRepresentation axisManagerRepresentation : axisManagers) {
            for (IAxisConfiguration current : axisManagerRepresentation.getSpecificAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != wantedDepth) continue;
                confs.add((TreeFillingConfiguration)current);
            }
        }
        return confs;
    }

    public static final List<TreeFillingConfiguration> getAllTreeFillingConfiguration(Table table) {
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        ArrayList<TreeFillingConfiguration> confs = new ArrayList<TreeFillingConfiguration>();
        LocalTableHeaderAxisConfiguration local = table.getLocalRowHeaderAxisConfiguration();
        if (local != null && !local.getAxisManagerConfigurations().isEmpty()) {
            for (AxisManagerConfiguration currentRep : local.getAxisManagerConfigurations()) {
                for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                    if (!(current instanceof TreeFillingConfiguration)) continue;
                    confs.add((TreeFillingConfiguration)current);
                }
            }
        } else {
            for (AxisManagerRepresentation axisManager : table.getTableConfiguration().getRowHeaderAxisConfiguration().getAxisManagers()) {
                for (IAxisConfiguration axisConf : axisManager.getSpecificAxisConfigurations()) {
                    if (!(axisConf instanceof TreeFillingConfiguration)) continue;
                    confs.add((TreeFillingConfiguration)axisConf);
                }
            }
        }
        return confs;
    }

    public static final boolean hasTreeFillingConfiguration(Table table, AxisManagerRepresentation representedAxisManager) {
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        LocalTableHeaderAxisConfiguration local = table.getLocalRowHeaderAxisConfiguration();
        if (local != null) {
            for (AxisManagerConfiguration currentRep : local.getAxisManagerConfigurations()) {
                if (currentRep.getAxisManager() != representedAxisManager) continue;
                for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                    if (!(current instanceof TreeFillingConfiguration)) continue;
                    return true;
                }
            }
        } else {
            for (IAxisConfiguration current : representedAxisManager.getSpecificAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration)) continue;
                return true;
            }
        }
        return false;
    }

    public static final List<TreeFillingConfiguration> getTreeFillingConfigurationForDepth(Table table, AxisManagerRepresentation representedAxisManager, int depth) {
        List<TreeFillingConfiguration> confs = FillingConfigurationUtils.getTreeFillingConfiguration(table, representedAxisManager);
        ListIterator<TreeFillingConfiguration> iter = confs.listIterator();
        while (iter.hasNext()) {
            if (((TreeFillingConfiguration)iter.next()).getDepth() == depth) continue;
            iter.remove();
        }
        return confs;
    }

    public static final boolean hasTreeFillingConfigurationForDepth(Table table, AxisManagerRepresentation representedAxisManager, int depth) {
        Iterator<TreeFillingConfiguration> iter = FillingConfigurationUtils.getTreeFillingConfigurationForDepth(table, representedAxisManager, depth).iterator();
        while (iter.hasNext()) {
            if (iter.next().getDepth() != depth) continue;
            return true;
        }
        return false;
    }

    public static final Collection<IFillingConfiguration> getFillingConfigurationUsedInTable(Table table, boolean onColumn) {
        ArrayList<IFillingConfiguration> confs = new ArrayList<IFillingConfiguration>();
        AbstractHeaderAxisConfiguration tableHeaderAxisConfiguration = onColumn ? HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table) : HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        for (IAxisConfiguration currentConfiguration : tableHeaderAxisConfiguration.getOwnedAxisConfigurations()) {
            if (!(currentConfiguration instanceof IFillingConfiguration)) continue;
            confs.add((IFillingConfiguration)currentConfiguration);
        }
        return confs;
    }

    public static String getElementTypeIdToCreate(Table table, boolean onColumn) {
        Collection<IFillingConfiguration> fillingConfiguration = FillingConfigurationUtils.getFillingConfigurationUsedInTable(table, onColumn);
        for (IFillingConfiguration iFillingConfiguration : fillingConfiguration) {
            if (!(iFillingConfiguration instanceof PasteEObjectConfiguration)) continue;
            return ((PasteEObjectConfiguration)fillingConfiguration).getPastedElementId();
        }
        return null;
    }

    public static EStructuralFeature getContainmentFeature(Table table, boolean onColumn) {
        Collection<IFillingConfiguration> fillingConfiguration = FillingConfigurationUtils.getFillingConfigurationUsedInTable(table, onColumn);
        for (IFillingConfiguration iFillingConfiguration : fillingConfiguration) {
            if (!(iFillingConfiguration instanceof PasteEObjectConfiguration)) continue;
            return ((PasteEObjectConfiguration)fillingConfiguration).getPasteElementContainementFeature();
        }
        return null;
    }

    public static boolean hasTreeFillingConfigurationForDepth(Table table, int depth) {
        EList localReps;
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        LocalTableHeaderAxisConfiguration local = table.getLocalRowHeaderAxisConfiguration();
        if (local != null && !(localReps = local.getAxisManagerConfigurations()).isEmpty()) {
            for (AxisManagerConfiguration currentRep : localReps) {
                for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                    if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != depth) continue;
                    return true;
                }
            }
            return false;
        }
        EList representation = table.getTableConfiguration().getRowHeaderAxisConfiguration().getAxisManagers();
        for (AxisManagerRepresentation currentRep : representation) {
            for (IAxisConfiguration current : currentRep.getSpecificAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != depth) continue;
                return true;
            }
        }
        return false;
    }

    public static int getMaxDepthForTree(Table table) {
        Iterator iter;
        int previousValue;
        Assert.isTrue((!table.isInvertAxis() ? 1 : 0) != 0, (String)INVERT_AXIS_CASE_NOT_YET_MANAGED_FOR_TREE_TABLE);
        TreeSet<Integer> hiddenLevels = new TreeSet<Integer>();
        LocalTableHeaderAxisConfiguration local = table.getLocalRowHeaderAxisConfiguration();
        if (local != null && !local.getAxisManagerConfigurations().isEmpty()) {
            for (AxisManagerConfiguration currentRep : local.getAxisManagerConfigurations()) {
                for (IAxisConfiguration current : currentRep.getLocalSpecificConfigurations()) {
                    int depth;
                    if (!(current instanceof TreeFillingConfiguration) || (depth = ((TreeFillingConfiguration)current).getDepth()) < 0) continue;
                    hiddenLevels.add(depth);
                }
            }
        } else {
            EList representation = table.getTableConfiguration().getRowHeaderAxisConfiguration().getAxisManagers();
            for (AxisManagerRepresentation currentRep : representation) {
                for (IAxisConfiguration current : currentRep.getSpecificAxisConfigurations()) {
                    int depth;
                    if (!(current instanceof TreeFillingConfiguration) || (depth = ((TreeFillingConfiguration)current).getDepth()) < 0) continue;
                    hiddenLevels.add(depth);
                }
            }
        }
        if (hiddenLevels.size() > 0 && ((previousValue = ((Integer)(iter = hiddenLevels.iterator()).next()).intValue()) == 0 || previousValue == 1)) {
            while (iter.hasNext()) {
                int nextValue = (Integer)iter.next();
                if (nextValue == previousValue + 1) {
                    previousValue = nextValue;
                    continue;
                }
                return previousValue;
            }
            return previousValue;
        }
        return 0;
    }
}

