/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.modelexplorer.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.sirius.editor.modelexplorer.internal.commands.RenameSiriusDiagramLabelCommand;
import org.eclipse.papyrus.sirius.editor.modelexplorer.internal.handlers.AbstractSiriusDiagramCommandHandler;
import org.eclipse.papyrus.sirius.editor.modelexplorer.internal.messages.Messages;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RenameSiriusDiagramHandler
extends AbstractSiriusDiagramCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        List<DSemanticDiagram> siriusDiagrams = this.getSelectedDSemanticDiagrams();
        if (editingDomain != null && siriusDiagrams.size() == 1) {
            DSemanticDiagram siriusDiagram = siriusDiagrams.get(0);
            String siriusDiagramLabel = LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)siriusDiagram, (boolean)true);
            if (siriusDiagramLabel != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)siriusDiagram)) {
                RenameSiriusDiagramLabelCommand cmd = new RenameSiriusDiagramLabelCommand(editingDomain, "ChangeDSemanticDiagramLabelCommand", (EObject)siriusDiagram, siriusDiagramLabel, Messages.RenameSiriusDiagramHandler_Label_DialogTitle);
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            String currentName = siriusDiagram.getName();
            if (currentName != null) {
                EAttribute nameFeature = ViewpointPackage.eINSTANCE.getDRepresentation_Name();
                return new RenameElementCommand(editingDomain, "RenameSiriusDiagramCommand", (EObject)siriusDiagram, currentName, (EStructuralFeature)nameFeature, Messages.RenameSiriusDiagramHandler_RenameAnExistingDSemanticDiagram, Messages.RenameSiriusDiagramHandler_NewName);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean computeEnabled = super.computeEnabled(context);
        if (computeEnabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            computeEnabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return computeEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedSiriusDiagram = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedSiriusDiagram)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedSiriusDiagram);
        } else {
            super.execute(event);
        }
        return null;
    }
}

