/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DiagramHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.diagram.model.business.internal.operations.DDiagramSpecOperations;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class DiagramServices {
    private static DiagramServices singleton = null;

    public static DiagramServices getDiagramServices() {
        if (singleton == null) {
            singleton = new DiagramServices();
        }
        return singleton;
    }

    public DEdge findDEdgeElement(DDiagram pDiagram, EdgeTarget sourceNode, EdgeTarget targetNode, EObject semanticObject, EdgeMapping mapping) {
        for (DEdge anEdge : DDiagramSpecOperations.getEdgesFromMapping((DDiagram)pDiagram, (EdgeMapping)mapping)) {
            if (anEdge.getTarget() == null || !anEdge.getTarget().equals(semanticObject) || !anEdge.getSourceNode().equals(sourceNode) || !anEdge.getTargetNode().equals(targetNode)) continue;
            return anEdge;
        }
        return null;
    }

    public DEdge createEdge(EdgeMapping mapping, EdgeTarget sourceView, EdgeTarget targetView, EObject semanticObject) {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticObject);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticObject);
        if (mapping == null) {
            return null;
        }
        if (sourceView == null || targetView == null) {
            return null;
        }
        DDiagram diagram = DiagramHelper.getService().getDiagramContainer((EObject)sourceView);
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DEdgeCandidate edgeCandidate = new DEdgeCandidate(mapping, semanticObject, sourceView, targetView, rId);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diagram.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        HashMap edgeToMappingBasedDecoration = new HashMap();
        HashMap edgeToSemanticBasedDecoration = new HashMap();
        HashMap mappingsToEdgeTargets = new HashMap();
        DDiagramElement sourceElement = null;
        DDiagramElement targetElement = null;
        DiagramElementMapping sourceMapping = null;
        DiagramElementMapping targetMapping = null;
        if (sourceView instanceof DDiagramElement) {
            sourceElement = (DDiagramElement)sourceView;
            sourceMapping = sourceElement.getDiagramElementMapping();
        }
        if (targetView instanceof DDiagramElement) {
            targetElement = (DDiagramElement)targetView;
            targetMapping = targetElement.getDiagramElementMapping();
        }
        if (sourceMapping != null) {
            mappingsToEdgeTargets.put(sourceMapping, new ArrayList());
        }
        if (targetMapping != null && !targetMapping.equals(sourceMapping)) {
            mappingsToEdgeTargets.put(targetMapping, new ArrayList());
        }
        if (sourceMapping != null) {
            ((Collection)mappingsToEdgeTargets.get(sourceMapping)).add(sourceView);
        }
        if (targetMapping != null && !sourceView.equals(targetView)) {
            ((Collection)mappingsToEdgeTargets.get(targetMapping)).add(targetView);
        }
        DecorationHelperInternal decorationHelper = new DecorationHelperInternal(diagram, interpreter, accessor);
        decorationHelper.computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
        return elementSync.createNewEdge(this.getMappingManager((DSemanticDiagram)diagram), edgeCandidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
    }

    private DiagramMappingsManager getMappingManager(DSemanticDiagram diagram) {
        Session session = SessionManager.INSTANCE.getSession(diagram.getTarget());
        return DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, (DDiagram)diagram);
    }

    public Set<DEdge> getOutgoingEdges(EdgeTarget node) {
        DDiagram diagram = DiagramHelper.getService().getDiagramContainer((EObject)node);
        HashSet<DEdge> returnedSet = new HashSet<DEdge>();
        returnedSet.addAll((Collection<DEdge>)node.getOutgoingEdges());
        returnedSet.retainAll((Collection<?>)diagram.getEdges());
        return returnedSet;
    }

    public EdgeMapping getEdgeMapping(DiagramDescription description, String mappingName) {
        for (EdgeMapping edgeMapping : description.getEdgeMappings()) {
            if (!edgeMapping.getName().equals(mappingName)) continue;
            return edgeMapping;
        }
        return null;
    }

    public EdgeMapping getEdgeMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        return this.getEdgeMapping(description, mappingName);
    }

    public DiagramElementMapping getEdgeMapping(DEdge aEdge) {
        if (aEdge != null && aEdge.getActualMapping() != null) {
            IEdgeMapping mapping = aEdge.getActualMapping();
            if (mapping != null && mapping instanceof EdgeMappingImport) {
                mapping = MappingHelper.getEdgeMapping((EdgeMappingImport)((EdgeMappingImport)mapping));
            }
            if (mapping != null && mapping instanceof DiagramElementMapping) {
                return (DiagramElementMapping)mapping;
            }
        }
        return null;
    }

    public boolean isABorderedNode(AbstractDNode node) {
        if (node == null) {
            return false;
        }
        EObject container = node.eContainer();
        if (container == null) {
            return false;
        }
        if (container instanceof DDiagram) {
            return false;
        }
        if (container instanceof AbstractDNode) {
            AbstractDNode nodeContainer = (AbstractDNode)container;
            return nodeContainer.getOwnedBorderedNodes().contains((Object)node);
        }
        return false;
    }

    public void removeNodeView(DNode node) {
        EObject container = node.eContainer();
        if (container != null) {
            if (container instanceof DDiagram) {
                ((DDiagram)container).getOwnedDiagramElements().remove((Object)node);
            }
            if (container instanceof DNodeContainer) {
                DNodeContainer nodeContainer = (DNodeContainer)container;
                if (nodeContainer.getOwnedDiagramElements().contains((Object)node)) {
                    nodeContainer.getOwnedDiagramElements().remove((Object)node);
                }
                if (nodeContainer.getOwnedBorderedNodes().contains((Object)node)) {
                    nodeContainer.getOwnedBorderedNodes().remove((Object)node);
                }
            }
            if (container instanceof DNode) {
                ((DNode)container).getOwnedBorderedNodes().remove((Object)node);
            }
        }
    }

    public void removeNodeListElementView(AbstractDNode node) {
        EObject container = node.eContainer();
        if (container != null && container instanceof DNodeList) {
            ((DNodeList)container).getOwnedElements().remove((Object)node);
        }
    }

    public void removeAbstractDNodeView(AbstractDNode node) {
        EObject container = node.eContainer();
        if (container != null) {
            if (container instanceof DDiagram) {
                ((DDiagram)container).getOwnedDiagramElements().remove((Object)node);
            } else if (container instanceof DNodeContainer) {
                DNodeContainer nodeContainer = (DNodeContainer)container;
                if (nodeContainer.getOwnedDiagramElements().contains((Object)node)) {
                    nodeContainer.getOwnedDiagramElements().remove((Object)node);
                }
                if (nodeContainer.getOwnedBorderedNodes().contains((Object)node)) {
                    nodeContainer.getOwnedBorderedNodes().remove((Object)node);
                }
            } else if (container instanceof DNode) {
                ((DNode)container).getOwnedBorderedNodes().remove((Object)node);
            } else if (container instanceof DNodeList) {
                ((DNodeList)container).getOwnedElements().remove((Object)node);
            }
        }
    }

    public void removeContainerView(EObject container) {
        EObject owner = container.eContainer();
        if (owner != null) {
            DNodeContainer nodeContainer;
            if (owner instanceof DDiagram) {
                ((DDiagram)owner).getOwnedDiagramElements().remove((Object)container);
            }
            if (owner instanceof DNodeContainer && (nodeContainer = (DNodeContainer)owner).getOwnedDiagramElements().contains((Object)container)) {
                nodeContainer.getOwnedDiagramElements().remove((Object)container);
            }
        }
    }

    public AbstractDNode createNode(NodeMapping mapping, EObject modelElement, DragAndDropTarget container, DDiagram diagram) {
        DDiagram diag = diagram;
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(modelElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        DDiagramSynchronizer diagramSync = new DDiagramSynchronizer(interpreter, diag.getDescription(), accessor);
        diagramSync.setDiagram((DSemanticDiagram)diagram);
        DDiagramElementSynchronizer elementSync = diagramSync.getElementSynchronizer();
        RefreshIdsHolder rId = RefreshIdsHolder.getOrCreateHolder((EObject)diagram);
        DNodeCandidate nodeCandidate = new DNodeCandidate((AbstractNodeMapping)mapping, modelElement, container, rId);
        return elementSync.createNewNode(this.getMappingManager((DSemanticDiagram)diag), nodeCandidate, false);
    }

    public DiagramElementMapping getMappingByName(RepresentationDescription targetDescription, String targetMappingName) {
        NodeMapping mapping = null;
        if (targetMappingName != null && targetDescription != null && targetDescription instanceof DiagramDescription && (mapping = DiagramServices.getDiagramServices().getAbstractNodeMapping((DiagramDescription)targetDescription, targetMappingName)) == null) {
            mapping = DiagramServices.getDiagramServices().getEdgeMapping((DiagramDescription)targetDescription, targetMappingName);
        }
        return mapping;
    }

    public NodeMapping getAbstractNodeMapping(DiagramDescription description, String mappingName) {
        for (NodeMapping nodeMapping : description.getNodeMappings()) {
            if (nodeMapping.getName().equals(mappingName)) {
                return nodeMapping;
            }
            for (NodeMapping borderedMapping : nodeMapping.getBorderedNodeMappings()) {
                if (!borderedMapping.getName().equals(mappingName)) continue;
                return borderedMapping;
            }
        }
        for (NodeMapping nodeMapping : description.getContainerMappings()) {
            if (nodeMapping.getName().equals(mappingName)) {
                return nodeMapping;
            }
            ArrayList<ContainerMapping> visited = new ArrayList<ContainerMapping>();
            NodeMapping anm = this.getAbstractNodeInSubMapping(mappingName, (ContainerMapping)nodeMapping, visited);
            if (anm == null) continue;
            return anm;
        }
        return null;
    }

    private NodeMapping getAbstractNodeInSubMapping(String mappingName, ContainerMapping nodeMapping, List<ContainerMapping> visited) {
        visited.add(nodeMapping);
        for (DiagramElementMapping mapping : nodeMapping.getSubNodeMappings()) {
            NodeMapping result;
            if (!(mapping instanceof NodeMapping)) continue;
            if (mapping.getName().equals(mappingName)) {
                return (NodeMapping)mapping;
            }
            for (NodeMapping borderedMapping : ((NodeMapping)mapping).getBorderedNodeMappings()) {
                if (!borderedMapping.getName().equals(mappingName)) continue;
                return borderedMapping;
            }
            if (!(nodeMapping instanceof ContainerMapping) || !(mapping instanceof ContainerMapping) || visited.contains(mapping) || (result = this.getAbstractNodeInSubMapping(mappingName, (ContainerMapping)mapping, visited)) == null) continue;
            return result;
        }
        return null;
    }

    public ContainerMapping getContainerMapping(DDiagram diagram, String mappingName) {
        DiagramDescription description = diagram.getDescription();
        for (ContainerMapping aContainerMapping : description.getContainerMappings()) {
            for (ContainerMapping aSubContainerMapping : this.getAllContainerMappings(aContainerMapping)) {
                if (!aSubContainerMapping.getName().equals(mappingName)) continue;
                return aSubContainerMapping;
            }
        }
        return null;
    }

    public List<ContainerMapping> getAllContainerMappings(ContainerMapping mapping) {
        ArrayList<ContainerMapping> returnedList = new ArrayList<ContainerMapping>();
        returnedList.add(mapping);
        for (ContainerMapping aMapping : mapping.getSubContainerMappings()) {
            returnedList.addAll(this.getAllContainerMappings(aMapping));
        }
        return returnedList;
    }

    public void removeEdgeView(DEdge anEdge) {
        EObject container = anEdge.eContainer();
        if (container != null && container instanceof DDiagram) {
            if (anEdge.getSourceNode() != null) {
                anEdge.getSourceNode().getIncomingEdges().remove((Object)anEdge);
                anEdge.getSourceNode().getOutgoingEdges().remove((Object)anEdge);
            }
            if (anEdge.getTargetNode() != null) {
                anEdge.getTargetNode().getOutgoingEdges().remove((Object)anEdge);
                anEdge.getTargetNode().getIncomingEdges().remove((Object)anEdge);
            }
            ((DDiagram)container).getOwnedDiagramElements().remove((Object)anEdge);
        }
    }

    public boolean isFilterActivate(String filterName, DDiagram ddiag) {
        EList activatedFilters = ddiag.getActivatedFilters();
        for (FilterDescription filterDescription : activatedFilters) {
            if (!filterName.equalsIgnoreCase(filterDescription.getName())) continue;
            return true;
        }
        return false;
    }
}

