/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.communication.services;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class CommunicationDiagramServices
extends AbstractDiagramServices {
    public boolean canCreateObservationCOD(EObject container, EClass objectToCreate, String containmentReferenceName) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        return commonDiagramServices.canCreate((EObject)this.getPackageContainer(container), objectToCreate, containmentReferenceName);
    }

    public EObject createObservationCOD(Element parent, String type, String referenceName, DSemanticDecorator targetView) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        return commonDiagramServices.createElement((Element)this.getPackageContainer((EObject)parent), type, referenceName, targetView);
    }

    public Collection<Observation> getObservationCandidates(EObject semanticContext) {
        Collection<Object> observations = Collections.emptyList();
        if (semanticContext == null) {
            return observations;
        }
        if (semanticContext instanceof Package) {
            EList packageElements = ((Package)semanticContext).getPackagedElements();
            observations = packageElements.stream().filter(Observation.class::isInstance).map(Observation.class::cast).collect(Collectors.toList());
        } else {
            observations = this.getObservationCandidates((EObject)this.getPackageContainer(semanticContext));
        }
        return observations;
    }

    public EObject createDomainBasedEdgeCOD(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        EObject newEdge = domainBasedEdgeServices.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView);
        if (newEdge instanceof Message) {
            this.initializeMessage((Message)newEdge, source, target);
        }
        return newEdge;
    }

    private void initializeMessage(Message message, EObject source, EObject target) {
        message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        if (source instanceof Lifeline || source instanceof ExecutionSpecification) {
            MessageOccurrenceSpecification sendEvent = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
            message.getInteraction().getFragments().add((Object)sendEvent);
            sendEvent.setName(message.getName() + "SendEvent");
            sendEvent.setMessage(message);
            message.setSendEvent((MessageEnd)sendEvent);
            if (source instanceof Lifeline) {
                sendEvent.setCovered((Lifeline)source);
            } else if (source instanceof ExecutionSpecification) {
                sendEvent.setCovered((Lifeline)((ExecutionSpecification)source).getCovereds().get(0));
            }
        }
        if (target instanceof Lifeline || target instanceof ExecutionSpecification) {
            MessageOccurrenceSpecification receiveEvent = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
            message.getInteraction().getFragments().add((Object)receiveEvent);
            receiveEvent.setName(message.getName() + "ReceiveEvent");
            receiveEvent.setMessage(message);
            message.setReceiveEvent((MessageEnd)receiveEvent);
            if (target instanceof Lifeline) {
                receiveEvent.setCovered((Lifeline)target);
            } else if (target instanceof ExecutionSpecification) {
                receiveEvent.setCovered((Lifeline)((ExecutionSpecification)target).getCovereds().get(0));
            }
        }
    }

    private Package getPackageContainer(EObject element) {
        if (element != null) {
            if (element instanceof Package) {
                return (Package)element;
            }
            return this.getPackageContainer(element.eContainer());
        }
        return null;
    }
}

