/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionUtils;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.util.CollectionUtil;

public class ConversionCollection
implements EDataType.Internal.ConversionDelegate {
    private final CollectionType fMyType;

    public ConversionCollection(CollectionType type) {
        this.fMyType = type;
    }

    public String convertToString(Object value) {
        EClassifier elementType = (EClassifier)this.fMyType.getElementType();
        if (!(value instanceof Collection) || !(elementType instanceof EDataType)) {
            return "";
        }
        ConversionUtils.setupConversionDelegate(elementType);
        StringBuilder result = new StringBuilder();
        Collection collection = (Collection)value;
        for (Object element : collection) {
            if (result.length() > 0) {
                result.append(", ");
            }
            String data = elementType.getEPackage().getEFactoryInstance().convertToString((EDataType)elementType, element);
            if (ConversionUtils.isStringType(elementType)) {
                data = ConversionCollection.escapeCollectionElem(data);
            }
            result.append(data);
        }
        return result.insert(0, "[").append("]").toString();
    }

    public Object createFromString(String literal) {
        EClassifier elementType = (EClassifier)this.fMyType.getElementType();
        if (!(elementType instanceof EDataType)) {
            throw new IllegalArgumentException("Invalid datatype: " + elementType.getName());
        }
        if ((literal = literal.trim()).length() > 0 && literal.charAt(0) == '[') {
            if (literal.charAt(literal.length() - 1) != ']') {
                throw new IllegalArgumentException("Invalid datatype: " + elementType.getName());
            }
            literal = literal.substring(1, literal.length() - 1);
        }
        ConversionUtils.setupConversionDelegate(elementType);
        MutableList result = Utils.createList();
        int i = 0;
        while (i < literal.length()) {
            int endIndex = ConversionCollection.extractCollectionElement(literal, i);
            Object value = ConversionUtils.createFromString(elementType, ConversionCollection.unescapeString(literal.substring(i, endIndex)).trim());
            result.add(value);
            i = endIndex;
            ++i;
        }
        if (this.fMyType instanceof ListType) {
            return result;
        }
        if (this.fMyType instanceof SetType) {
            return CollectionUtil.createNewSet(result);
        }
        if (this.fMyType instanceof OrderedSetType) {
            return CollectionUtil.createNewOrderedSet(result);
        }
        if (this.fMyType instanceof SequenceType) {
            return CollectionUtil.createNewSequence(result);
        }
        if (this.fMyType instanceof BagType) {
            return CollectionUtil.createNewBag(result);
        }
        throw new IllegalArgumentException("Invalid datatype: " + this.fMyType.getName());
    }

    private static String escapeCollectionElem(String literal) {
        StringBuilder result = new StringBuilder(literal.length());
        int i = 0;
        while (i < literal.length()) {
            char ch = literal.charAt(i);
            switch (ch) {
                case ',': 
                case '[': 
                case '\\': 
                case ']': {
                    result.append('\\');
                }
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    static String unescapeString(String literal) {
        char[] convtBuf = new char[literal.length()];
        int outLen = 0;
        int i = 0;
        while (i < literal.length()) {
            char ch = literal.charAt(i);
            switch (ch) {
                case '\\': {
                    if (++i >= literal.length()) break;
                    convtBuf[outLen] = literal.charAt(i);
                    break;
                }
                default: {
                    convtBuf[outLen] = ch;
                }
            }
            ++outLen;
            ++i;
        }
        return new String(convtBuf, 0, outLen);
    }

    private static int extractCollectionElement(String literal, int startIndex) {
        int level = 0;
        int i = startIndex;
        while (i < literal.length()) {
            switch (literal.charAt(i)) {
                case '\\': {
                    ++i;
                    break;
                }
                case '[': {
                    ++level;
                    break;
                }
                case ']': {
                    --level;
                    break;
                }
                case ',': {
                    if (level != 0) break;
                    return i;
                }
            }
            ++i;
        }
        return literal.length();
    }
}

