/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.ui.internal.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.dialog.ColorLabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialog;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.exported.exception.IllegalParameterException;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;

public class LoadCustomizationsDialog<D>
extends Dialog
implements ILoadCustomizationsDialog<D> {
    private static final int TREE_WIDTH = 300;
    private static final int TREE_HEIGHT = 250;
    private static final int NUM_COLUMNS = 4;
    private final List<Customization> availableCustoms;
    private final LabelProvider labelProvider;
    private final IContentProvider contentProvider = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            List customizations = (List)inputElement;
            return customizations.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    };
    private final EList<Customization> selectedCustomizations;
    private TreeViewer availableCustomizationsTreeViewer;
    private TreeViewer selectedCustomizationsTreeViewer;
    private Button addButton;
    private Button removeButton;
    private Button addAllButton;
    private Button removeAllButton;
    private Button upButton;
    private Button downButton;
    private Button loadRequiredFacetsCheckbox;
    private boolean loadRequiredFacetsSelected = false;
    private final IDialogCallbackWithPreCommit<List<Customization>, Boolean, D> callback;
    private final List<Customization> lockedCustoms;
    private final String lockMsg;

    public LoadCustomizationsDialog(Shell parent, List<Customization> availableCustomizations, List<Customization> selectedCustoms, List<Customization> lockedCustoms, IDialogCallbackWithPreCommit<List<Customization>, Boolean, D> callback, String lockMsg) {
        super(parent);
        this.labelProvider = new ColorLabelProvider(this);
        this.callback = callback;
        this.selectedCustomizations = new BasicEList();
        this.availableCustoms = new ArrayList<Customization>(availableCustomizations);
        this.lockedCustoms = lockedCustoms;
        this.lockMsg = lockMsg;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        for (Customization initiallySelectedCustomization : selectedCustoms) {
            URI initiallySelectedCustomizationURI = EcoreUtil.getURI((EObject)initiallySelectedCustomization);
            ListIterator<Customization> availableCustomizationsIterator = this.availableCustoms.listIterator();
            while (availableCustomizationsIterator.hasNext()) {
                Customization availableCustomization = availableCustomizationsIterator.next();
                URI availableCustomizationURI = EcoreUtil.getURI((EObject)availableCustomization);
                if (!availableCustomizationURI.equals(initiallySelectedCustomizationURI)) continue;
                availableCustomizationsIterator.remove();
                this.selectedCustomizations.add((Object)initiallySelectedCustomization);
            }
        }
        for (Customization lockedCustom : this.lockedCustoms) {
            if (this.selectedCustomizations.contains((Object)lockedCustom)) continue;
            this.selectedCustomizations.add((Object)lockedCustom);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LoadCustomizationsDialog_title_LoadCustomizations);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 4;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        this.createLeftPane(contents);
        this.createMiddleButtonsPane(contents);
        this.createRightPane(contents);
        this.createRightButtonsPane(contents);
        this.createLoadRequiredFacetsCheckbox(contents);
        this.availableCustomizationsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LoadCustomizationsDialog.this.loadSelectedCustoms();
            }
        });
        this.selectedCustomizationsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LoadCustomizationsDialog.this.unloadSelectedCustoms();
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.upButtonClicked();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.downButtonClicked();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.loadSelectedCustoms();
            }
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.addAllButtonClicked();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.unloadSelectedCustoms();
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.removeAllButtonClicked();
            }
        });
        return contents;
    }

    public final void upButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedCustomizationsTreeViewer.getSelection();
        int minIndex = 0;
        for (Object selectedObject : selection.toList()) {
            if (!(selectedObject instanceof Customization)) continue;
            Customization customization = (Customization)selectedObject;
            int index = this.selectedCustomizations.indexOf((Object)customization);
            this.selectedCustomizations.move(Math.max(index - 1, minIndex++), (Object)customization);
        }
        this.selectedCustomizationsTreeViewer.refresh();
    }

    public final void downButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedCustomizationsTreeViewer.getSelection();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            selectedObjects.add(selectedObject);
            ++n2;
        }
        boolean canMove = !selectedObjects.contains(this.selectedCustomizations.get(this.selectedCustomizations.size() - 1));
        int i = this.selectedCustomizations.size() - 2;
        while (i >= 0) {
            Customization selectedCustomization = (Customization)this.selectedCustomizations.get(i);
            if (selectedObjects.contains(selectedCustomization)) {
                if (canMove) {
                    this.selectedCustomizations.move(i + 1, (Object)selectedCustomization);
                }
            } else {
                canMove = true;
            }
            --i;
        }
        this.selectedCustomizationsTreeViewer.refresh();
    }

    @Override
    public final void loadSelectedCustoms() {
        IStructuredSelection selection = (IStructuredSelection)this.availableCustomizationsTreeViewer.getSelection();
        for (Object object : selection.toList()) {
            Customization custom;
            if (!(object instanceof Customization) || this.selectedCustomizations.contains((Object)(custom = (Customization)object))) continue;
            this.selectedCustomizations.add((Object)custom);
            this.availableCustoms.remove(custom);
        }
        this.refresh();
        this.selectedCustomizationsTreeViewer.setSelection((ISelection)selection);
    }

    public final void addAllButtonClicked() {
        ListIterator<Customization> listIterator = this.availableCustoms.listIterator();
        while (listIterator.hasNext()) {
            Customization element = listIterator.next();
            this.selectedCustomizations.add((Object)element);
            listIterator.remove();
        }
        this.refresh();
    }

    @Override
    public final void unloadSelectedCustoms() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedCustomizationsTreeViewer.getSelection();
        ArrayList<Customization> toBeRemoved = new ArrayList<Customization>();
        boolean lockedCustomFound = false;
        for (Object object : selection.toList()) {
            if (this.lockedCustoms.contains(object)) {
                lockedCustomFound = true;
                continue;
            }
            if (!(object instanceof Customization)) continue;
            Customization element = (Customization)object;
            toBeRemoved.add(element);
        }
        if (lockedCustomFound) {
            MessageDialog dialog = new MessageDialog(null, Messages.LoadCustomizationsDialog_LoadCustomizationWarning, null, Messages.LoadCustomizationsDialog_Can_not_be_unload + this.lockMsg, 4, new String[]{Messages.LoadCustomizationsDialog_OK}, 1);
            dialog.open();
        }
        this.removeFromSelection(toBeRemoved);
        this.refresh();
    }

    protected void removeFromSelection(List<Customization> toBeRemoved) {
        ArrayList<Customization> customizations = new ArrayList<Customization>(toBeRemoved);
        for (Customization element : customizations) {
            this.selectedCustomizations.remove((Object)element);
            this.availableCustoms.add(element);
        }
        if (this.selectedCustomizations.size() > 0) {
            this.selectedCustomizationsTreeViewer.setSelection((ISelection)new StructuredSelection(this.selectedCustomizations.get(0)));
        }
    }

    public final void removeAllButtonClicked() {
        this.removeFromSelection((List<Customization>)this.selectedCustomizations);
        this.refresh();
    }

    private void createLeftPane(Composite contents) {
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(Messages.LoadCustomizationsDialog_AvailiableCustom);
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        final Text patternText = LoadCustomizationsDialog.createFilterText(choiceComposite);
        Tree availableCustomizationsTree = new Tree(choiceComposite, 2050);
        GridData availableCustomizationsGridData = new GridData();
        availableCustomizationsGridData.widthHint = 300;
        availableCustomizationsGridData.heightHint = 250;
        availableCustomizationsGridData.horizontalAlignment = 4;
        availableCustomizationsGridData.verticalAlignment = 4;
        availableCustomizationsGridData.grabExcessHorizontalSpace = true;
        availableCustomizationsGridData.grabExcessVerticalSpace = true;
        availableCustomizationsTree.setLayoutData((Object)availableCustomizationsGridData);
        this.availableCustomizationsTreeViewer = new TreeViewer(availableCustomizationsTree);
        this.availableCustomizationsTreeViewer.setContentProvider(this.contentProvider);
        this.availableCustomizationsTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        final PatternFilter filter = new PatternFilter();
        this.availableCustomizationsTreeViewer.addFilter((ViewerFilter)filter);
        this.availableCustomizationsTreeViewer.setInput(this.availableCustoms);
        patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                filter.setPattern(patternText.getText());
                LoadCustomizationsDialog.this.availableCustomizationsTreeViewer.refresh();
            }
        });
    }

    private void createMiddleButtonsPane(Composite contents) {
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 0x1000000;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setText(Messages.LoadCustomizationsDialog_Add);
        this.addButton.setToolTipText(Messages.LoadCustomizationsDialog_Add2);
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.removeButton = new Button(buttonsComposite, 8);
        this.removeButton.setText(Messages.LoadCustomizationsDialog_Remove);
        this.removeButton.setToolTipText(Messages.LoadCustomizationsDialog_Remove2);
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        this.removeButton.setLayoutData((Object)removeButtonGridData);
        LoadCustomizationsDialog.spacer(buttonsComposite);
        this.addAllButton = new Button(buttonsComposite, 8);
        this.addAllButton.setText(Messages.LoadCustomizationsDialog_AddAll);
        this.addAllButton.setToolTipText(Messages.LoadCustomizationsDialog_AddAll2);
        this.removeAllButton = new Button(buttonsComposite, 8);
        this.removeAllButton.setText(Messages.LoadCustomizationsDialog_RemoveAll);
        this.removeAllButton.setToolTipText(Messages.LoadCustomizationsDialog_RemoveAll2);
    }

    private static void spacer(Composite parent) {
        Label label = new Label(parent, 0);
    }

    private void createRightButtonsPane(Composite contents) {
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 4;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        LoadCustomizationsDialog.spacer(buttonsComposite);
        this.upButton = new Button(buttonsComposite, 8);
        this.upButton.setText(Messages.LoadCustomizationsDialog_Up);
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button(buttonsComposite, 8);
        this.downButton.setText(Messages.LoadCustomizationsDialog_Down);
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)downButtonGridData);
    }

    private void createRightPane(Composite contents) {
        Composite featureComposite = new Composite(contents, 0);
        GridData featureCompositeData = new GridData(4, 4, true, true);
        featureCompositeData.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)featureCompositeData);
        GridLayout featureCompositeLayout = new GridLayout();
        featureCompositeData.horizontalAlignment = 4;
        featureCompositeLayout.marginHeight = 0;
        featureCompositeLayout.marginWidth = 0;
        featureCompositeLayout.numColumns = 1;
        featureComposite.setLayout((Layout)featureCompositeLayout);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(Messages.LoadCustomizationsDialog_LoadedCustomizations);
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)featureLabelGridData);
        Tree loadedCustomizationsTree = new Tree(featureComposite, 2050);
        GridData loadedCustomizationsGridData = new GridData();
        loadedCustomizationsGridData.widthHint = 300;
        loadedCustomizationsGridData.heightHint = 250;
        loadedCustomizationsGridData.verticalAlignment = 4;
        loadedCustomizationsGridData.horizontalAlignment = 4;
        loadedCustomizationsGridData.grabExcessHorizontalSpace = true;
        loadedCustomizationsGridData.grabExcessVerticalSpace = true;
        loadedCustomizationsTree.setLayoutData((Object)loadedCustomizationsGridData);
        this.selectedCustomizationsTreeViewer = new TreeViewer(loadedCustomizationsTree);
        this.selectedCustomizationsTreeViewer.setContentProvider(this.contentProvider);
        this.selectedCustomizationsTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.selectedCustomizationsTreeViewer.setInput(this.selectedCustomizations);
    }

    private void createLoadRequiredFacetsCheckbox(Composite contents) {
        LoadCustomizationsDialog.spacer(contents);
        LoadCustomizationsDialog.spacer(contents);
        this.loadRequiredFacetsCheckbox = new Button(contents, 32);
        this.loadRequiredFacetsCheckbox.setText(Messages.LoadCustomizationsDialog_loadReferencedFacetsCheckbox);
        this.loadRequiredFacetsCheckbox.setSelection(true);
        this.loadRequiredFacetsCheckbox.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
    }

    private static Text createFilterText(Composite contents) {
        Text patternText = new Text(contents, 2176);
        patternText.setMessage(Messages.LoadCustomizationsDialog_type_filter_test);
        patternText.setLayoutData((Object)new GridData(768));
        return patternText;
    }

    protected void okPressed() {
        this.pressOk();
    }

    public void commit(Boolean result) {
        this.callback.committed(this.selectedCustomizations, (Object)result);
        super.okPressed();
    }

    public boolean isLoadRequiredFacetsSelected() {
        return this.loadRequiredFacetsSelected;
    }

    @Override
    public List<Customization> getSelectedCustomizations() {
        return this.selectedCustomizations;
    }

    private void refresh() {
        this.availableCustomizationsTreeViewer.refresh();
        this.selectedCustomizationsTreeViewer.refresh();
    }

    @Override
    public void asyncOpen() {
        Display display = this.getShell() == null ? Display.getDefault() : this.getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                LoadCustomizationsDialog.this.open();
            }
        });
    }

    @Override
    public D pressOk() {
        this.loadRequiredFacetsSelected = this.loadRequiredFacetsCheckbox.getSelection();
        Object preCommitDialog = this.callback.openPrecommitDialog(this.selectedCustomizations, (IDialogCallback)new IDialogCallback<Boolean>(){

            public void committed(Boolean result) {
                if (result.booleanValue()) {
                    LoadCustomizationsDialog.this.commit(result);
                }
            }
        });
        if (preCommitDialog == null) {
            this.callback.committed(this.selectedCustomizations, (Object)Boolean.TRUE);
            super.okPressed();
        }
        return (D)preCommitDialog;
    }

    @Override
    public void selectAvailableCustom(Customization customization) {
        StructuredSelection selection = new StructuredSelection((Object)customization);
        this.availableCustomizationsTreeViewer.setSelection((ISelection)selection);
    }

    @Override
    public void selectSelectedCustom(Customization customization) {
        StructuredSelection selection = new StructuredSelection((Object)customization);
        this.selectedCustomizationsTreeViewer.setSelection((ISelection)selection);
    }

    public List<Customization> getLockedCustoms() {
        return this.lockedCustoms;
    }

    @Override
    public void addCustomization(Customization customization) throws IllegalParameterException {
    }

    @Override
    public void addCustomizations(List<Customization> customizations) throws IllegalParameterException {
    }

    @Override
    public void removeCustomization(Customization customization) throws IllegalParameterException {
    }

    @Override
    public void removeCustomizations(List<Customization> customizations) throws IllegalParameterException {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void validate() {
    }

    @Override
    public List<Customization> getAvailableCustomizations() {
        return null;
    }

    @Override
    public void pushUp(Customization customization) throws IllegalParameterException {
    }

    @Override
    public void pushDown(Customization customization) throws IllegalParameterException {
    }
}

