/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class ElementTypeFactoryDescriptor {
    private final IConfigurationElement configElement;
    private IElementTypeFactory elementTypeFactory;
    private String factoryName;
    private final String kindName;
    private final List params;

    public ElementTypeFactoryDescriptor(IConfigurationElement configElement) throws CoreException {
        this.configElement = configElement;
        this.factoryName = configElement.getAttribute("factory");
        if (this.factoryName == null) {
            throw EMFTypePluginStatusCodes.getFactoryInitException("", EMFTypeCoreMessages.elementTypeFactory_reason_no_factory_WARN_);
        }
        this.kindName = configElement.getAttribute("kind");
        if (this.kindName == null) {
            throw EMFTypePluginStatusCodes.getFactoryInitException(this.factoryName, EMFTypeCoreMessages.elementTypeFactory_reason_no_kind_WARN_);
        }
        String paramString = configElement.getAttribute("params");
        this.params = new ArrayList();
        if (paramString != null) {
            StringTokenizer t = new StringTokenizer(paramString, ",");
            while (t.hasMoreTokens()) {
                String nextParam = t.nextToken().trim();
                this.params.add(nextParam);
            }
        }
    }

    public IElementTypeFactory getElementTypeFactory() {
        if (this.elementTypeFactory == null && this.factoryName != null) {
            try {
                this.elementTypeFactory = (IElementTypeFactory)this.configElement.createExecutableExtension("factory");
            }
            catch (CoreException e) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)24, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.elementTypeFactory_class_not_found_ERROR_, (Object)this.factoryName), (Throwable)e);
                this.factoryName = null;
            }
        }
        return this.elementTypeFactory;
    }

    public String getKindName() {
        return this.kindName;
    }

    public List getParams() {
        return this.params;
    }
}

