/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.XtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.RuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.SubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.WebProjectConfig;

public class XtextProjectConfig
implements IXtextProjectConfig {
    private RuntimeProjectConfig runtime = new RuntimeProjectConfig();
    private BundleProjectConfig runtimeTest = new BundleProjectConfig();
    private BundleProjectConfig genericIde = new BundleProjectConfig();
    private BundleProjectConfig eclipsePlugin = new BundleProjectConfig();
    private BundleProjectConfig eclipsePluginTest = new BundleProjectConfig();
    private WebProjectConfig web = new WebProjectConfig();
    @Inject
    private CodeConfig codeConfig;

    public void checkConfiguration(Issues issues) {
        for (SubProjectConfig subProjectConfig : this.getEnabledProjects()) {
            subProjectConfig.checkConfiguration(issues);
        }
    }

    public List<? extends SubProjectConfig> getAllProjects() {
        return Lists.newArrayList((Object[])new SubProjectConfig[]{this.runtime, this.runtimeTest, this.genericIde, this.eclipsePlugin, this.eclipsePluginTest, this.web});
    }

    public List<? extends SubProjectConfig> getTestProjects() {
        return Lists.newArrayList((Object[])new BundleProjectConfig[]{this.runtimeTest, this.eclipsePluginTest});
    }

    public List<? extends SubProjectConfig> getEnabledProjects() {
        ArrayList enabledProjects = new ArrayList();
        Iterables.addAll(enabledProjects, (Iterable)Iterables.filter(this.getAllProjects(), SubProjectConfig::isEnabled));
        return enabledProjects;
    }

    @Override
    public void initialize(Injector injector) {
        this.setDefaults();
        injector.injectMembers((Object)this);
        for (SubProjectConfig subProjectConfig : this.getEnabledProjects()) {
            subProjectConfig.initialize(injector);
        }
    }

    public void setDefaults() {
        this.runtime.setEnabled(true);
        if (this.eclipsePlugin.isEnabled() || this.web.isEnabled()) {
            this.genericIde.setEnabled(true);
        }
    }

    protected ManifestAccess newManifestAccess() {
        ManifestAccess manifestAccess = new ManifestAccess();
        manifestAccess.setLineDelimiter(this.codeConfig.getLineDelimiter());
        return manifestAccess;
    }

    protected PluginXmlAccess newPluginXmlAccess() {
        return new PluginXmlAccess();
    }

    protected XtextGeneratorFileSystemAccess newFileSystemAccess(String path, boolean overWrite) {
        return new XtextGeneratorFileSystemAccess(path, overWrite);
    }

    @Override
    public RuntimeProjectConfig getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RuntimeProjectConfig runtime) {
        this.runtime = runtime;
    }

    @Override
    public BundleProjectConfig getRuntimeTest() {
        return this.runtimeTest;
    }

    public void setRuntimeTest(BundleProjectConfig runtimeTest) {
        this.runtimeTest = runtimeTest;
    }

    @Override
    public BundleProjectConfig getGenericIde() {
        return this.genericIde;
    }

    public void setGenericIde(BundleProjectConfig genericIde) {
        this.genericIde = genericIde;
    }

    @Override
    public BundleProjectConfig getEclipsePlugin() {
        return this.eclipsePlugin;
    }

    public void setEclipsePlugin(BundleProjectConfig eclipsePlugin) {
        this.eclipsePlugin = eclipsePlugin;
    }

    @Override
    public BundleProjectConfig getEclipsePluginTest() {
        return this.eclipsePluginTest;
    }

    public void setEclipsePluginTest(BundleProjectConfig eclipsePluginTest) {
        this.eclipsePluginTest = eclipsePluginTest;
    }

    @Override
    public WebProjectConfig getWeb() {
        return this.web;
    }

    public void setWeb(WebProjectConfig web) {
        this.web = web;
    }

    public CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    public void setCodeConfig(CodeConfig codeConfig) {
        this.codeConfig = codeConfig;
    }
}

