/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.util.MergeTraceAdapter;

public class MergedADElement
extends NotifierImpl
implements IAdaptable {
    protected MergedADElement parent;
    protected ADElement element;

    @Deprecated(since="3.1", forRemoval=true)
    public MergedADElement(MergedADElement parent) {
        this(parent, null);
    }

    public MergedADElement(MergedADElement parent, ADElement element) {
        this.parent = parent;
        this.element = element;
    }

    protected ADElement getModel() {
        return this.element;
    }

    public MergedADElement getParent() {
        return this.parent;
    }

    void setParent(MergedArchitectureDomain domain) {
        this.parent = domain;
    }

    public String getId() {
        return this.element.getId();
    }

    public String getName() {
        return this.element.getName();
    }

    public String getQualifiedName() {
        return this.element.getQualifiedName();
    }

    public String getDescription() {
        return this.element.getDescription();
    }

    public String getIcon() {
        return this.element.getIcon();
    }

    @Deprecated(since="3.1", forRemoval=true)
    public ADElement getImageObject() {
        return this.element;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.element});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MergedADElement)) {
            return false;
        }
        MergedADElement other = (MergedADElement)((Object)obj);
        if (other.parent != this.parent) {
            return false;
        }
        return Objects.equal((Object)other.element, (Object)this.element);
    }

    public String toString() {
        return this.element != null ? this.element.toString() : super.toString();
    }

    @Deprecated(since="3.1", forRemoval=true)
    public int getElementsNumber() {
        return this.element != null ? 1 : 0;
    }

    public boolean isMerged() {
        MergeTraceAdapter trace = MergeTraceAdapter.getMergeTraces((ADElement)this.getModel());
        return trace != null && trace.trace(this.getModel()).size() > 1;
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = this.getModel() == null ? Platform.getAdapterManager().getAdapter((Object)this, adapter) : (adapter == EObject.class || adapter.isInstance(this.getModel()) ? adapter.cast(this.getModel()) : (adapter == Resource.class ? adapter.cast(this.getModel().eResource()) : (adapter == ResourceSet.class ? adapter.cast(this.getModel().eResource().getResourceSet()) : Platform.getAdapterManager().getAdapter((Object)this, adapter))));
        return (T)result;
    }
}

