/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.core.internal.exported;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.FolderUtils;
import org.osgi.framework.Bundle;

public final class FileUtils {
    private static final int COPY_BUFFER_SIZE = 524288;

    private FileUtils() {
    }

    public static String getFileContents(Bundle bundle, String path) throws IOException {
        URL url = bundle.getResource(path);
        if (url == null) {
            return null;
        }
        InputStream source = url.openStream();
        return FileUtils.readInputStream(source);
    }

    public static String readInputStream(InputStream stream) throws IOException {
        return FileUtils.readInputStream(stream, "UTF-8");
    }

    public static String readInputStream(InputStream stream, String charset) throws IOException {
        int read;
        int bufferSize = 65536;
        char[] buffer = new char[65536];
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(stream, charset);
        do {
            if ((read = ((Reader)reader).read(buffer, 0, buffer.length)) <= 0) continue;
            builder.append(buffer, 0, read);
        } while (read >= 0);
        ((Reader)reader).close();
        return builder.toString();
    }

    public static void copyFolderFromBundle(String folderPath, IProject project, String destinationPath, Bundle bundleContainingResources, boolean recurse) throws IOException, CoreException {
        Enumeration files = bundleContainingResources.findEntries(folderPath, "*.*", recurse);
        while (files.hasMoreElements()) {
            URL element = (URL)files.nextElement();
            Object filename = element.getFile().replace(folderPath, "");
            if (!((String)filename).startsWith("/")) {
                filename = "/" + (String)filename;
            }
            FileUtils.copyFileFromBundle(element.getFile(), project, destinationPath + (String)filename, bundleContainingResources);
        }
    }

    public static IFile copyFileFromBundle(String sourcePath, IProject project, String destinationPath, Bundle bundleContainingResources) throws IOException, CoreException {
        IFile javaFile;
        InputStream source;
        block10: {
            URL url = bundleContainingResources.getResource(sourcePath);
            if (url != null) {
                source = url.openStream();
            } else {
                url = bundleContainingResources.getEntry(sourcePath);
                if (url == null) {
                    throw new IOException(sourcePath + " not found.");
                }
                source = url.openStream();
            }
            javaFile = project.getFile(destinationPath);
            if (javaFile.exists()) {
                try {
                    javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    if (!project.isOpen()) break block10;
                    try {
                        project.close((IProgressMonitor)new NullProgressMonitor());
                        javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        project.open((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        }
        if (!javaFile.getParent().exists()) {
            FolderUtils.createFolder((IFolder)javaFile.getParent());
        }
        javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
        return javaFile;
    }

    public static final boolean copyFile(File source, File destination) {
        boolean result = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            try {
                int nbRead;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbRead = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbRead);
                }
                result = true;
            }
            catch (FileNotFoundException f) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e) {
                    result = false;
                }
            }
            catch (IOException e) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                }
                catch (Exception e2) {
                    result = false;
                }
            }
        }
        finally {
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
                if (destinationFile != null) {
                    destinationFile.close();
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }
}

