/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.javabean.metadata.properties;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.internal.utils.ObjectUtil;
import org.eclipse.xwt.javabean.metadata.properties.AbstractProperty;

public class FieldProperty
extends AbstractProperty {
    private Field field;

    public FieldProperty(Field field) {
        super(field.getName(), field.getType());
        this.field = field;
    }

    @Override
    public Object getValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        return this.field.get(target);
    }

    @Override
    public void setValue(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        Class<?> valueType;
        Class<?> fieldType;
        if (value != null && !ObjectUtil.isAssignableFrom(fieldType = this.field.getType(), valueType = value.getClass())) {
            IConverter converter = XWT.findConvertor(valueType, fieldType);
            if (converter != null) {
                value = converter.convert(value);
            } else {
                throw new XWTException("Converter " + valueType.getName() + "->" + fieldType.getName());
            }
        }
        this.field.set(target, value);
        this.fireSetPostAction(target, this, value);
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

