/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.ui;

import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ControlResourceDialog
extends ResourceDialog {
    private EditingDomain domain;
    private Resource controlResource;
    private Resource currentResource;
    private String defaultName;

    public ControlResourceDialog(Shell parent, EditingDomain theDomain, Resource theCurrentResource, String defaultName) {
        super(parent, EMFEditUIPlugin.INSTANCE.getString("_UI_ControlDialog_title"), 8192);
        this.domain = theDomain;
        this.currentResource = theCurrentResource;
        this.defaultName = defaultName;
    }

    private String computeDefaultURI() {
        String ext = this.currentResource.getURI().fileExtension();
        URI uri = this.currentResource.getURI().trimSegments(1);
        uri = uri.appendSegment(this.defaultName).appendFileExtension(ext);
        return uri.toString();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.uriField.setText(this.computeDefaultURI());
        return result;
    }

    protected boolean processResources() {
        boolean resourceInSet;
        URI uri = URI.createURI((String)this.getURIText());
        ResourceSet resourceSet = this.domain.getResourceSet();
        Resource resource = resourceSet.getResource(uri, false);
        boolean bl = resourceInSet = resource != null;
        if (resource == this.currentResource) {
            MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AlreadyInResource"));
            return false;
        }
        if (this.domain.isReadOnly(resource)) {
            MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReadOnlyResource"));
            return false;
        }
        boolean resourceExists = resourceSet.getURIConverter().exists(uri, null);
        boolean resourceBad = false;
        if (!resourceInSet) {
            resource = resourceSet.createResource(uri);
            if (resource == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
                return false;
            }
            if (resourceExists) {
                try {
                    resource = resourceSet.getResource(uri, true);
                }
                catch (RuntimeException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                    resourceBad = resource.getContents().isEmpty();
                }
            }
        }
        boolean result = true;
        if (resourceBad) {
            result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReplaceResource"));
        } else if (resourceExists) {
            result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AddToResource"));
        }
        if (!result && !resourceInSet && resource != null) {
            resource.unload();
            resourceSet.getResources().remove((Object)resource);
        } else {
            this.controlResource = resource;
        }
        return result;
    }

    public Resource getControlResource() {
        return this.controlResource;
    }
}

