/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.AbstractDecoratorModelRefactoringCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands.DirectionConstraint;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelResourceSet;
import org.eclipse.papyrus.uml.decoratormodel.model.DecoratorModel;

class UnloadedDecoratorModelRefactoringCommand
extends AbstractDecoratorModelRefactoringCommand {
    protected UnloadedDecoratorModelRefactoringCommand(PackageRefactoringContext context, URI decoratorModelURI) {
        super(context, decoratorModelURI);
    }

    protected UnloadedDecoratorModelRefactoringCommand(PackageRefactoringContext context, URI decoratorModelURI, DirectionConstraint direction) {
        super(context, decoratorModelURI, direction);
    }

    @Override
    protected ResourceSet getResourceSet() {
        return new DecoratorModelResourceSet();
    }

    @Override
    protected Resource getResource(ResourceSet resourceSet, URI decoratorModelURI) {
        return resourceSet.getResource(decoratorModelURI, true);
    }

    @Override
    protected void disposeResourceSet(ResourceSet resourceSet) {
        EMFHelper.unload((ResourceSet)resourceSet);
    }

    @Override
    protected void resourceRefactored(Resource resource, boolean changed) throws ExecutionException {
        if (changed) {
            try {
                resource.save(new DecoratorModel().getSaveOptions());
            }
            catch (IOException e) {
                throw new ExecutionException(Messages.UnloadedDecoratorModelRefactoringCommand_0, (Throwable)e);
            }
        }
    }
}

