/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.destroy.DestroyerStatus;
import org.eclipse.papyrus.uml.domain.services.destroy.ElementDestroyer;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;

public class DeleteServices {
    public boolean delete(EObject objectToRemove) {
        ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)objectToRemove);
        ElementDestroyer destroyer = ElementDestroyer.buildDefault((ECrossReferenceAdapter)crossReferenceAdapter, (IEditableChecker)new EditableChecker());
        DestroyerStatus status = destroyer.destroy(objectToRemove);
        Set elements = status.getElements();
        return status.getState() == State.DONE && elements != null && !elements.isEmpty();
    }

    public void deleteLink(Element linkSource, DEdge edgeView) {
        Optional<Element> optionalSemanticTarget = this.getSemanticTarget(edgeView);
        if (optionalSemanticTarget.isPresent()) {
            Element semanticTarget = optionalSemanticTarget.get();
            if (linkSource instanceof Constraint) {
                Constraint constraint = (Constraint)linkSource;
                constraint.getConstrainedElements().remove((Object)semanticTarget);
            } else if (linkSource instanceof Comment) {
                Comment comment = (Comment)linkSource;
                comment.getAnnotatedElements().remove((Object)semanticTarget);
            }
        }
    }

    private Optional<Element> getSemanticTarget(DEdge edgeView) {
        return Optional.ofNullable(edgeView).map(DEdge::getTargetNode).filter(DSemanticDecorator.class::isInstance).map(DSemanticDecorator.class::cast).map(DSemanticDecorator::getTarget).filter(Element.class::isInstance).map(Element.class::cast);
    }
}

