/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class NavigateToVarDeclAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        try {
            Object object = selection.getFirstElement();
            if (object instanceof IJavaVariable) {
                IStackFrame jFrame;
                IJavaVariable varE = (IJavaVariable)object;
                final String name = varE.getName();
                IAdaptable frame = DebugUITools.getDebugContext();
                if (frame instanceof IStackFrame && (jFrame = (IStackFrame)frame) instanceof IJavaStackFrame) {
                    IJavaStackFrame javaStackFrame = (IJavaStackFrame)jFrame;
                    String type = javaStackFrame.getLaunch().getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(type);
                    IJavaProject iJavaProject = JavaCore.create((IProject)project);
                    IType iType = iJavaProject.findType(javaStackFrame.getReceivingTypeName());
                    final String currentMethod = javaStackFrame.getMethodName();
                    List frameParams = javaStackFrame.getArgumentTypeNames();
                    final List ref = frameParams.stream().map(e -> {
                        int dot = e.lastIndexOf(46);
                        if (dot >= 0) {
                            return e.substring(dot + 1);
                        }
                        return e;
                    }).collect(Collectors.toList());
                    final ICompilationUnit cu = iType.getCompilationUnit();
                    ASTParser parse = ASTParser.newParser((int)AST.getJLSLatest());
                    parse.setSource(cu);
                    parse.setKind(8);
                    parse.setResolveBindings(true);
                    final CompilationUnit ast = (CompilationUnit)parse.createAST(null);
                    ast.accept(new ASTVisitor(){
                        boolean meth = false;
                        boolean found = false;

                        public boolean visit(MethodDeclaration node) {
                            List parameters;
                            List<String> methodParams;
                            if (node.getName().getIdentifier().equals(currentMethod) && (methodParams = (parameters = node.parameters()).stream().map(p -> ((SingleVariableDeclaration)p).getType().toString()).toList()).equals(ref)) {
                                this.meth = true;
                                for (Object op : node.parameters()) {
                                    SingleVariableDeclaration parm = (SingleVariableDeclaration)op;
                                    if (!parm.getName().getIdentifier().equals(name)) continue;
                                    NavigateToVarDeclAction.this.highlightLine(ast, cu, node.getStartPosition());
                                    this.found = true;
                                    return false;
                                }
                                return true;
                            }
                            return true;
                        }

                        public boolean visit(VariableDeclarationFragment node) {
                            if (this.found) {
                                return false;
                            }
                            if (this.meth && node.getName().getIdentifier().equals(name)) {
                                this.found = true;
                                NavigateToVarDeclAction.this.highlightLine(ast, cu, node.getStartPosition());
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
        }
        catch (Exception e2) {
            DebugUIPlugin.log((Throwable)e2);
        }
    }

    private void highlightLine(CompilationUnit ast, ICompilationUnit cu, int startPos) {
        int line = ast.getLineNumber(startPos);
        try {
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)cu);
            if (editor instanceof ITextEditor) {
                ITextEditor txtEd = (ITextEditor)editor;
                IDocumentProvider prov = txtEd.getDocumentProvider();
                IDocument doc = prov.getDocument((Object)txtEd.getEditorInput());
                IRegion lineReg = doc.getLineInformation(line - 1);
                txtEd.selectAndReveal(lineReg.getOffset(), lineReg.getLength());
            }
        }
        catch (Exception e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }
}

