/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.representation.architecture;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.sirius.editor.internal.viewpoint.SiriusDiagramViewPrototype;
import org.eclipse.papyrus.sirius.editor.representation.ICreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.papyrus.sirius.editor.representation.architecture.AbstractCreateSiriusDiagramEditorCommand;
import org.eclipse.papyrus.sirius.editor.representation.architecture.internal.messages.Messages;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.helper.SiriusDiagramHelper;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;

public class CreatePapyrusSiriusStateMachineDiagramEditorCommand
extends AbstractCreateSiriusDiagramEditorCommand
implements ICreateSiriusDiagramEditorCommand {
    public static final int defaultX = 30;
    public static final int defaultY = 30;
    public static final int defaultWidth = 700;
    public static final int defaultHeight = 300;
    public static final int defaultHeader = 20;

    private String askName(ViewPrototype prototype, EObject semanticContext) {
        String defaultName = this.getDefaultName(prototype, semanticContext);
        return this.askDiagramName(Messages.CreatePapyrusSiriusDiagramEditorCommand_CreateSiriusDiagramDialogTitle, defaultName);
    }

    private String getDefaultName(ViewPrototype prototype, EObject semanticContext) {
        StringBuilder nameBuilder = new StringBuilder(prototype.getLabel().replaceAll(" ", ""));
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)DiagramPackage.eINSTANCE.getDDiagram(), (EStructuralFeature)ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Name(), (String)nameBuilder.toString(), (EObject)semanticContext);
        return nameWithIncrement;
    }

    public DSemanticDiagram execute(ViewPrototype prototype, String name, EObject semanticContext, boolean openAfterCreation) {
        return this.execute(prototype, name, semanticContext, semanticContext, openAfterCreation);
    }

    public DSemanticDiagram execute(ViewPrototype prototype, String name, final EObject semanticContext, final EObject graphicalContext, final boolean openAfterCreation) {
        if (prototype instanceof SiriusDiagramViewPrototype) {
            String diagramName;
            PapyrusRepresentationKind representation = prototype.getRepresentationKind();
            Assert.isTrue((boolean)(representation instanceof SiriusDiagramPrototype), (String)"The representation associated to the PapyrusDSemanticDiagramViewPrototype must be an instanceof SiriusDiagramPrototype.");
            final SiriusDiagramPrototype docProto = (SiriusDiagramPrototype)representation;
            String string = diagramName = name == null || name.isEmpty() ? this.askName(prototype, semanticContext) : name;
            if (diagramName == null) {
                return null;
            }
            try {
                ServicesRegistry serviceRegistry = ServiceUtilsForResourceSet.getInstance().getServiceRegistry(semanticContext.eResource().getResourceSet());
                TransactionalEditingDomain ted = (TransactionalEditingDomain)serviceRegistry.getService(TransactionalEditingDomain.class);
                final DSemanticDiagram[] result = new DSemanticDiagram[1];
                ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                    protected void doExecute() {
                        Element sm = CreatePapyrusSiriusStateMachineDiagramEditorCommand.this.initializeModel(semanticContext);
                        DSemanticDiagram ddiagram = CreatePapyrusSiriusStateMachineDiagramEditorCommand.super.execute(docProto, diagramName, (EObject)sm, graphicalContext, openAfterCreation, docProto.getImplementationID());
                        DiagramDescription desc = ddiagram.getDescription();
                        CreatePapyrusSiriusStateMachineDiagramEditorCommand.this.initializeDiagram((DDiagram)ddiagram, desc, sm);
                        result[0] = ddiagram;
                    }
                });
                return result[0];
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Element initializeModel(EObject owner) {
        if (owner instanceof StateMachine) {
            StateMachine sm = (StateMachine)owner;
            this.initDefaultRegion(sm);
            return sm;
        }
        if (owner instanceof State) {
            State state = (State)owner;
            EList regions = state.getRegions();
            if (regions.isEmpty()) {
                Region region = UMLFactory.eINSTANCE.createRegion();
                regions.add((Object)region);
                region.setName(NamedElementUtil.getDefaultNameWithIncrement((EObject)region, (Collection)regions));
            }
            return state;
        }
        StateMachine stateMachine = UMLFactory.eINSTANCE.createStateMachine();
        if (owner instanceof BehavioredClassifier) {
            BehavioredClassifier behaviorClassifier = (BehavioredClassifier)owner;
            behaviorClassifier.getOwnedBehaviors().add((Object)stateMachine);
        } else if (owner instanceof Package) {
            Package pack = (Package)owner;
            pack.getPackagedElements().add((Object)stateMachine);
        }
        this.init_StateMachine_Shape(stateMachine);
        this.initDefaultRegion(stateMachine);
        return stateMachine;
    }

    private void initDefaultRegion(StateMachine sm) {
        EList regions = sm.getRegions();
        if (regions.isEmpty()) {
            Region region = UMLFactory.eINSTANCE.createRegion();
            regions.add((Object)region);
            region.setName(NamedElementUtil.getDefaultNameWithIncrement((EObject)region, (Collection)regions));
        }
    }

    public void init_StateMachine_Shape(StateMachine instance) {
        try {
            String value_0 = this.name_StateMachine_Shape(instance);
            if (value_0 != null) {
                instance.setName(value_0);
            }
            Region newInstance_1_0 = UMLFactory.eINSTANCE.createRegion();
            instance.getRegions().add((Object)newInstance_1_0);
            String value_1_0_0 = this.name_region_StateMachine_Shape(newInstance_1_0);
            if (value_1_0_0 != null) {
                newInstance_1_0.setName(value_1_0_0);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private String name_StateMachine_Shape(StateMachine it) {
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)it, (Collection)it.getOwner().eContents());
    }

    private String name_Region_Shape(Region it) {
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)it, (Collection)it.getOwner().eContents());
    }

    private String name_region_StateMachine_Shape(Region it) {
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)it, (Collection)it.getOwner().eContents());
    }

    protected void initializeDiagram(DDiagram diagram, DiagramDescription desc, Element sm) {
        Region region = null;
        String regionMapping = "SMD_RegionCompartment";
        if (sm instanceof StateMachine) {
            StateMachine stateMachine = (StateMachine)sm;
            region = (Region)stateMachine.getRegions().get(0);
        } else if (sm instanceof State) {
            State state = (State)sm;
            region = (Region)state.getRegions().get(0);
        }
        if (region != null) {
            DNodeContainer compartment = (DNodeContainer)diagram.getOwnedDiagramElements().get(0);
            DNodeContainer newNode = DiagramFactory.eINSTANCE.createDNodeContainer();
            HideFilterHelper.INSTANCE.hideLabel((DDiagramElement)newNode);
            newNode.setTarget((EObject)region);
            String selector = "SMD_RegionCompartment";
            Optional<ContainerMapping> anyMatch = compartment.getActualMapping().getReusedContainerMappings().stream().filter(m -> "SMD_RegionCompartment".equals(m.getName())).findFirst();
            newNode.setActualMapping(anyMatch.get());
            newNode.setChildrenPresentation(ContainerLayout.FREE_FORM);
            SiriusDiagramHelper.addNodeInContainer((DragAndDropTarget)compartment, (boolean)false, (AbstractDNode)newNode);
        }
    }
}

