/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.profileapplication.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFProfileApplicationDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.Activator;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.profileapplication.internal.ProfileApplicationController;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.RegisteredProfileSelectionDialog;
import org.eclipse.papyrus.uml.tools.importsources.PackageImportSourceDialog;
import org.eclipse.papyrus.uml.tools.profile.definition.Version;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final String NAME_COLUMN_TITLE = "Name";
    private static final String LOCATION_COLUMN_TITLE = "Location";
    private static final String VERSION_COLUMN_TITLE = "Version";
    private static final String APPLY_BUTTON_TOOLTIP = "Apply profile";
    private static final String REMOVE_BUTTON_TOOLTIP = "Remove selected elements";
    private static final String APPLY_REGISTERED_BUTTON_TOOLTIP = "Apply registered profiles";
    private static final String REAPPLY_BUTTON_TOOLTIP = "Reapply profile";
    private static final String PAPYRUS_VERSION_EANNOTATION = "PapyrusVersion";
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private EEFProfileApplicationDescription description;
    private Package target;
    private ProfileApplicationController controller;
    private Composite mainComposite;
    private TableViewer tableViewer;
    private Button applyProfileButton;
    private Button removeButton;
    private Button applyRegisteredProfileButton;
    private Button reapplyButton;
    private ISelectionChangedListener tableSelectionChangedListener;
    private ButtonSelectionListener applyProfileButtonListener;
    private ButtonSelectionListener removeButtonListener;
    private ButtonSelectionListener applyRegisteredProfileButtonListener;
    private ButtonSelectionListener reapplyButtonListener;

    public ProfileApplicationLifecycleManager(EEFProfileApplicationDescription controlDescription, Package target, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = controlDescription;
        this.target = target;
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout mainCompositeLayout = new GridLayout(2, false);
        this.mainComposite.setLayout((Layout)mainCompositeLayout);
        GridData mainCompositeLayoutData = new GridData(4, 0x1000000, true, false);
        this.mainComposite.setLayoutData((Object)mainCompositeLayoutData);
        this.createTable(this.mainComposite);
        Composite buttonsComposite = this.createButtons(this.mainComposite);
        Point computedSize = buttonsComposite.computeSize(-1, -1);
        GridData tableGridData = (GridData)this.tableViewer.getTable().getLayoutData();
        tableGridData.heightHint = computedSize.y - this.tableViewer.getTable().getItemHeight();
        this.controller = new ProfileApplicationController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    protected void createTable(Composite parent) {
        int style = 0x10000008;
        int selectionStyle = 65540;
        int tableStyle = 2560;
        style = style | selectionStyle | tableStyle;
        Table table = new Table(parent, style);
        GridData tableGridData = new GridData(4, 128, true, false, 1, 1);
        tableGridData.widthHint = 150;
        table.setLayoutData((Object)tableGridData);
        this.tableViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout(true);
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setHeaderBackground(Display.getCurrent().getSystemColor(25));
        new TableColumn(table, 0).setText(NAME_COLUMN_TITLE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 150, true));
        new TableColumn(table, 0).setText(LOCATION_COLUMN_TITLE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 400, true));
        new TableColumn(table, 0).setText(VERSION_COLUMN_TITLE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 50, true));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProfileColumnsLabelProvider((IBaseLabelProvider)new UMLLabelProvider()));
        this.tableViewer.setInput(this.getInput());
    }

    private Set<Profile> getInput() {
        HashSet<Profile> profiles = new HashSet<Profile>((Collection<Profile>)this.target.getAppliedProfiles());
        for (Profile p : this.target.getAllAppliedProfiles()) {
            if (this.target.getProfileApplication(p, true) == null) continue;
            profiles.add(p);
        }
        return profiles;
    }

    protected Composite createButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridLayout buttonCompositeGridLayout = new GridLayout(1, false);
        buttonCompositeGridLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonCompositeGridLayout);
        GridData buttonCompositeGridData = new GridData(0x1000000, 0x1000000, false, false);
        buttonsComposite.setLayoutData((Object)buttonCompositeGridData);
        Image addImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Add_16x16.gif"));
        Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Delete_16x16.gif"));
        Image applyRegisteredImage = ExtendedImageRegistry.INSTANCE.getImage((Object)Activator.getDefault().getImage("AddRegistered_16x16.gif"));
        Image reaplyImage = ExtendedImageRegistry.INSTANCE.getImage((Object)Activator.getDefault().getImage("Refresh_16x16.gif"));
        this.applyProfileButton = this.createButton(buttonsComposite, addImage);
        this.removeButton = this.createButton(buttonsComposite, removeImage);
        this.applyRegisteredProfileButton = this.createButton(buttonsComposite, applyRegisteredImage);
        this.reapplyButton = this.createButton(buttonsComposite, reaplyImage);
        return buttonsComposite;
    }

    protected IEEFWidgetController getController() {
        return this.controller;
    }

    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.tableSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ProfileApplicationLifecycleManager.this.tableViewer.getSelection() instanceof IStructuredSelection) {
                    ProfileApplicationLifecycleManager.this.refresh();
                }
            }
        };
        this.tableViewer.addSelectionChangedListener(this.tableSelectionChangedListener);
        this.initializeApplyProfileButton();
        this.initializeRemoveButton();
        this.initializeApplyRegisteredProfileButton();
        this.initializeReapplyButton();
    }

    protected void initializeApplyProfileButton() {
        this.applyProfileButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.applyProfileButtonCallback());
        this.applyProfileButton.addSelectionListener((SelectionListener)this.applyProfileButtonListener);
        this.applyProfileButton.setToolTipText(APPLY_BUTTON_TOOLTIP);
    }

    private void applyProfileButtonCallback() {
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.profile.uml", "UML Profiles (*.profile.uml)");
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        Collection packages = PackageImportSourceDialog.open((Shell)Display.getCurrent().getActiveShell(), (String)"Apply Profiles...", Collections.singletonList(this.target), extensionFilters);
        if (packages == null || packages.isEmpty()) {
            return;
        }
        if (packages.size() > 0) {
            LinkedList<Profile> profilesToApply = new LinkedList<Profile>();
            Profile onlyOneProfile = ProfileUtil.getTheOnlyOneProfile((Collection)packages);
            if (onlyOneProfile == null) {
                ProfileTreeSelectionDialog profileDialog = new ProfileTreeSelectionDialog(Display.getCurrent().getActiveShell(), packages);
                if (profileDialog.open() != 0) {
                    throw new OperationCanceledException();
                }
                Collection profilesImportToApply = profileDialog.getResult();
                for (ElementImportTreeSelectionDialog.ImportSpec importProfile : profilesImportToApply) {
                    profilesToApply.add((Profile)importProfile.getElement());
                }
            } else {
                profilesToApply.add(onlyOneProfile);
            }
            this.applyProfiles(profilesToApply);
        }
        this.refresh();
    }

    private void applyProfiles(Collection<Profile> profilesToApply) {
        EList appliedProfiles = this.target.getAppliedProfiles();
        for (Profile profile : profilesToApply) {
            if (appliedProfiles.contains((Object)profile)) continue;
            this.target.applyProfile(profile);
        }
    }

    protected void initializeRemoveButton() {
        this.removeButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.removeButtonCallback());
        this.removeButton.addSelectionListener((SelectionListener)this.removeButtonListener);
        this.removeButton.setToolTipText(REMOVE_BUTTON_TOOLTIP);
    }

    private void removeButtonCallback() {
        List<Profile> selectedProfiles = this.selectionToList(this.tableViewer.getSelection());
        this.unapplyProfiles(selectedProfiles);
        this.refresh();
    }

    private void unapplyProfiles(List<Profile> profilesToUnapply) {
        for (Profile profileToRemove : profilesToUnapply) {
            this.target.unapplyProfile(profileToRemove);
        }
    }

    protected void initializeApplyRegisteredProfileButton() {
        this.applyRegisteredProfileButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.applyRegisteredProfileButtonCallback());
        this.applyRegisteredProfileButton.addSelectionListener((SelectionListener)this.applyRegisteredProfileButtonListener);
        this.applyRegisteredProfileButton.setToolTipText(APPLY_REGISTERED_BUTTON_TOOLTIP);
    }

    private void applyRegisteredProfileButtonCallback() {
        RegisteredProfileSelectionDialog profileSelectionDialog = new RegisteredProfileSelectionDialog((Composite)Display.getCurrent().getActiveShell(), this.target);
        List profilesToApply = profileSelectionDialog.run();
        this.applyProfiles(profilesToApply);
        this.refresh();
    }

    protected void initializeReapplyButton() {
        this.reapplyButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.reapplyButtonCallback());
        this.reapplyButton.addSelectionListener((SelectionListener)this.reapplyButtonListener);
        this.reapplyButton.setToolTipText(REAPPLY_BUTTON_TOOLTIP);
    }

    private void reapplyButtonCallback() {
        List<Profile> profilesToApply = this.selectionToList(this.tableViewer.getSelection());
        this.unapplyProfiles(profilesToApply);
        this.applyProfiles(profilesToApply);
        this.refresh();
    }

    private List<ProfileApplication> getSelectedProfileApplications() {
        List<Profile> selectionToList = this.selectionToList(this.tableViewer.getSelection());
        ArrayList<ProfileApplication> profileApplications = new ArrayList<ProfileApplication>();
        for (Profile selectedProfile : selectionToList) {
            ProfileApplication profileApplication = this.target.getProfileApplication(selectedProfile, true);
            if (profileApplication == null) continue;
            profileApplications.add(profileApplication);
        }
        return profileApplications;
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.tableViewer != null) {
            this.tableViewer.removeSelectionChangedListener(this.tableSelectionChangedListener);
        }
        this.removeListener(this.applyProfileButton, this.applyProfileButtonListener);
        this.removeListener(this.removeButton, this.removeButtonListener);
        this.removeListener(this.applyRegisteredProfileButton, this.applyRegisteredProfileButtonListener);
        this.removeListener(this.reapplyButton, this.reapplyButtonListener);
    }

    protected void removeListener(Button button, ButtonSelectionListener listener) {
        if (button != null && !button.isDisposed()) {
            button.removeSelectionListener((SelectionListener)listener);
        }
    }

    protected void setEnabled(boolean isEnabled) {
        boolean elementIsSelected;
        Table table = this.tableViewer.getTable();
        TableItem[] selection = table.getSelection();
        boolean bl = elementIsSelected = selection != null && selection.length > 0;
        if (this.applyProfileButton != null && !this.applyProfileButton.isDisposed()) {
            this.applyProfileButton.setEnabled(isEnabled);
        }
        if (this.applyRegisteredProfileButton != null && !this.applyRegisteredProfileButton.isDisposed()) {
            this.applyRegisteredProfileButton.setEnabled(isEnabled);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            if (elementIsSelected) {
                List<ProfileApplication> profileApplications = this.getSelectedProfileApplications();
                boolean allExternalized = false;
                for (ProfileApplication next : profileApplications) {
                    boolean bl2 = allExternalized = next.getApplyingPackage() == this.target;
                    if (!allExternalized) break;
                }
                this.removeButton.setEnabled(isEnabled && allExternalized);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        if (this.reapplyButton != null && !this.reapplyButton.isDisposed()) {
            if (elementIsSelected) {
                boolean enableReapply = false;
                for (Profile selectedProfile : this.selectionToList(this.tableViewer.getSelection())) {
                    if (!ProfileUtil.isDirty((Package)this.target, (Profile)selectedProfile)) continue;
                    enableReapply = true;
                    break;
                }
                this.reapplyButton.setEnabled(enableReapply && isEnabled);
            } else {
                this.reapplyButton.setEnabled(false);
            }
        }
    }

    public void refresh() {
        super.refresh();
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.setInput(this.getInput());
            this.tableViewer.refresh();
        }
        this.controller.refresh();
        this.setEnabled(this.isEnabled());
    }

    protected Control getValidationControl() {
        return this.mainComposite;
    }

    private List<Profile> selectionToList(ISelection selection) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Profile) {
                    profiles.add((Profile)object);
                }
                ++n2;
            }
        }
        return profiles;
    }

    protected Button createButton(Composite parent, Image image) {
        Button button = new Button(parent, 0);
        button.setImage(image);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 80;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected static class ButtonSelectionListener
    implements SelectionListener {
        private EditingContextAdapter editingContextAdapter;
        private Runnable runnable;

        public ButtonSelectionListener(EditingContextAdapter editingContextAdapter, Runnable runnable) {
            this.editingContextAdapter = editingContextAdapter;
            this.runnable = runnable;
        }

        public void widgetSelected(SelectionEvent event) {
            this.editingContextAdapter.performModelChange(this.runnable);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.editingContextAdapter.performModelChange(this.runnable);
        }
    }

    protected class ProfileColumnsLabelProvider
    extends StyledCellLabelProvider {
        private ILabelProvider defaultLabelProvider;
        private DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider;

        public ProfileColumnsLabelProvider(IBaseLabelProvider defaultLabelProvider) {
            if (defaultLabelProvider instanceof ILabelProvider) {
                this.defaultLabelProvider = (ILabelProvider)defaultLabelProvider;
            }
            if (defaultLabelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                this.styledLabelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)defaultLabelProvider;
            }
        }

        public void update(ViewerCell cell) {
            if (cell.getColumnIndex() == 0) {
                this.updateName(cell);
                return;
            }
            if (!((EObject)cell.getElement() instanceof Profile)) {
                cell.setText("");
                return;
            }
            Profile profile = (Profile)((EObject)cell.getElement());
            switch (cell.getColumnIndex()) {
                case 1: {
                    this.updateLocation(cell, profile);
                    break;
                }
                case 2: {
                    this.updateVersion(cell, profile);
                    break;
                }
            }
        }

        public void updateName(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            StyledString styledText = this.getStyledText(cell.getElement());
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
        }

        public void updateLocation(ViewerCell cell, Profile profile) {
            URI uri;
            String location = "Unknown";
            if (profile.eIsProxy()) {
                location = EcoreUtil.getURI((EObject)profile).trimFragment().toString();
            } else if (profile.eResource() != null && (uri = profile.eResource().getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }

        public void updateVersion(ViewerCell cell, Profile profile) {
            String versionText = this.getProfileVersion(profile);
            cell.setText(versionText);
        }

        private String getProfileVersion(Profile profile) {
            EAnnotation eAnnotation;
            Version version = Version.emptyVersion;
            if (profile != null && (eAnnotation = profile.getDefinition().getEAnnotation(ProfileApplicationLifecycleManager.PAPYRUS_VERSION_EANNOTATION)) != null) {
                String detailsVersion = (String)eAnnotation.getDetails().get((Object)ProfileApplicationLifecycleManager.VERSION_COLUMN_TITLE);
                version = new Version(detailsVersion);
            }
            return version.toString();
        }

        public Image getImage(Object element) {
            Image image = null;
            if (this.defaultLabelProvider != null) {
                image = this.defaultLabelProvider.getImage(element);
            }
            return image;
        }

        public StyledString getStyledText(Object element) {
            StyledString result;
            if (this.styledLabelProvider != null) {
                result = this.styledLabelProvider.getStyledText(element);
            } else {
                String string = this.defaultLabelProvider != null ? this.defaultLabelProvider.getText(element) : "";
                result = new StyledString(string);
            }
            ProfileApplication application = null;
            if (element instanceof Profile) {
                application = ProfileApplicationLifecycleManager.this.target.getProfileApplication((Profile)element, true);
            } else if (element instanceof ProfileApplication) {
                application = (ProfileApplication)element;
            }
            if (application != null && application.getApplyingPackage() != ProfileApplicationLifecycleManager.this.target) {
                String qualifier = " (profile application)";
                result.append(qualifier, StyledString.DECORATIONS_STYLER);
            }
            return result;
        }
    }
}

