/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.uml.types.core.commands.StereotypePropertyReferenceEdgeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class StereotypePropertyReferenceDestroyCommand
extends EditElementCommand {
    private final View view;
    private String stereotypeToSet;
    private String featureToSet;
    private final EObject referencedObject;
    private final EObject container;

    public StereotypePropertyReferenceDestroyCommand(DestroyReferenceRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        EAnnotation eAnnotation;
        this.referencedObject = request.getReferencedObject();
        this.container = request.getContainer();
        Object value = request.getParameters().get("AFFECTED_VIEW");
        View view = this.view = value instanceof View ? (View)value : null;
        if (this.view != null && (eAnnotation = this.view.getEAnnotation("StereotypePropertyReferenceEdge")) != null) {
            this.featureToSet = (String)eAnnotation.getDetails().get((Object)"featureToSet");
            this.stereotypeToSet = (String)eAnnotation.getDetails().get((Object)"stereotypeQualifiedName");
        }
    }

    public boolean canExecute() {
        boolean canExecute = false;
        if (this.view != null && this.featureToSet != null && this.stereotypeToSet != null) {
            canExecute = this.referencedObject instanceof Element && this.container instanceof Element;
        }
        return canExecute;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        return this.dereferenceTarget();
    }

    protected CommandResult dereferenceTarget() throws ExecutionException {
        try {
            Stereotype stereotype = this.getContainer().getApplicableStereotype(this.stereotypeToSet);
            Stereotype appliedSubstereotype = UMLUtil.getAppliedSubstereotype((Element)this.getContainer(), (Stereotype)stereotype);
            if (stereotype != null) {
                Property attribute = stereotype.getAttribute(this.featureToSet, null);
                if (1 == attribute.getUpper()) {
                    this.getContainer().setValue(appliedSubstereotype, this.featureToSet, null);
                    this.cleanOtherEdge(null);
                } else {
                    Object list = this.getContainer().getValue(appliedSubstereotype, this.featureToSet);
                    Type targetType = attribute.getType();
                    Object value = null;
                    value = targetType instanceof Stereotype ? ElementUtil.getStereotypeApplication(this.getReferencedObject(), (Stereotype)targetType) : this.getReferencedObject();
                    if (list instanceof List) {
                        ((List)list).remove(value);
                    }
                    this.cleanOtherEdge(list);
                }
            }
        }
        catch (IllegalArgumentException e) {
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult((Object)this.getContainer());
    }

    protected void cleanOtherEdge(Object value) throws ExecutionException {
        ICommand cleanStereotypePropertyReferenceCommand = StereotypePropertyReferenceEdgeUtil.getCleanStereotypePropertyReferenceCommand((EObject)this.container, (Object)value, (String)this.stereotypeToSet, (String)this.featureToSet, (TransactionalEditingDomain)this.getEditingDomain(), null);
        if (cleanStereotypePropertyReferenceCommand != null && cleanStereotypePropertyReferenceCommand.canExecute()) {
            cleanStereotypePropertyReferenceCommand.execute(null, null);
        }
    }

    public Element getReferencedObject() {
        return (Element)this.referencedObject;
    }

    public Element getContainer() {
        return (Element)this.container;
    }
}

