/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.builder;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.ecore.adapters.ResourceSetMappingMetaDataRegistryAdapter;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingConfigurationException;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTRootEnvironment;
import org.eclipse.qvt.declarative.parser.ui.preferences.QVTPreferences;

@Deprecated
public abstract class AbstractBuilder
extends IncrementalProjectBuilder {
    protected final ICreationFactory creationFactory;

    protected AbstractBuilder(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
    }

    protected void addMarker(int severity, IResource resource, String message, int lineNumber, int charStart, int charEnd) {
        String markerId = this.creationFactory.getProblemMarkerId();
        try {
            IMarker marker = resource.createMarker(markerId);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
            if (charStart <= charEnd) {
                marker.setAttribute("charStart", charStart);
                marker.setAttribute("charEnd", charEnd);
            }
        }
        catch (CoreException e) {
            QVTEditorPlugin.logError("Failed to add marker " + markerId, e);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            QVTPreferences.clean();
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void checkResource(IResource iResource, IProgressMonitor monitor) {
        if (iResource instanceof IFile && QVTPreferences.hasExtension((String)iResource.getFileExtension(), (String[])this.creationFactory.getTextExtensions())) {
            IFile file = (IFile)iResource;
            IPath concretePath = file.getFullPath();
            this.deleteMarkers((IResource)file);
            try {
                this.compile(file, monitor);
            }
            catch (IOException e) {
                this.addMarker(2, (IResource)file, "Internal error : " + e.getClass().getName() + " - see Error Log for details", 1, 1, 1);
                QVTEditorPlugin.logError("Failed to read '" + concretePath.toString() + "'", e);
            }
            catch (Throwable e) {
                this.addMarker(2, (IResource)file, "Internal error : " + e.getClass().getName() + " - see Error Log for details", 1, 1, 1);
                QVTEditorPlugin.logError("Failed to build '" + concretePath.toString() + "'", e);
                e.printStackTrace();
            }
        }
    }

    protected void compile(IFile file, IProgressMonitor progressMonitor) throws IOException, CoreException, MappingConfigurationException {
        IPath concretePath = file.getFullPath();
        IPath abstractPath = concretePath.removeFileExtension().addFileExtension(this.creationFactory.getXMLExtension());
        EclipseProjectHandle projectHandle = new EclipseProjectHandle(file.getProject());
        EclipseFileHandle fileHandle = projectHandle.getFileHandle((IResource)file);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)abstractPath.toString(), (boolean)true);
        boolean generateEMOF = QVTPreferences.generateEMOF();
        URI ecoreURI = generateEMOF ? uri.appendFileExtension("ecore") : uri;
        ICSTFileEnvironment environment = this.creationFactory.createFileEnvironment((FileHandle)fileHandle, (ResourceSet)resourceSet, ecoreURI);
        ProblemHandler reporter = this.creationFactory.createProblemHandler(file);
        environment.setProblemHandler(reporter);
        ICSTRootEnvironment rootEnvironment = environment.parse(null, environment.getFile(), progressMonitor);
        XMIResource resource = rootEnvironment.getASTNode();
        try {
            if (generateEMOF) {
                IMappingMetaData mappingMetaData = this.creationFactory.getMappingMetaData();
                IMappingMetaDataRegistry mappingMetaDataRegistry = ResourceSetMappingMetaDataRegistryAdapter.getMappingMetaDataRegistry((ResourceSet)resourceSet, (IMappingMetaData)mappingMetaData);
                resource = mappingMetaDataRegistry.getAdapter((Resource)resource, uri);
            }
            resource.save(null);
            rootEnvironment.validate();
        }
        catch (IOException e) {
            QVTEditorPlugin.logError("Failed to save '" + abstractPath.toString() + "'", e);
        }
        reporter.flush(BasicMonitor.toMonitor((IProgressMonitor)progressMonitor));
    }

    protected DeltaVisitor createDeltaVisitor(IProgressMonitor monitor) {
        return new DeltaVisitor(monitor);
    }

    protected ResourceVisitor createResourceVisitor(IProgressMonitor monitor) {
        return new ResourceVisitor(monitor);
    }

    protected void deleteMarkers(IResource resource) {
        String markerId = this.creationFactory.getProblemMarkerId();
        try {
            resource.deleteMarkers(markerId, false, 0);
        }
        catch (CoreException e) {
            QVTEditorPlugin.logError("Failed to delete resource markers for " + markerId, e);
        }
    }

    protected void fullBuild(IProgressMonitor monitor) {
        String markerId = this.creationFactory.getProblemMarkerId();
        try {
            IProject project = this.getProject();
            project.deleteMarkers(markerId, false, 2);
            project.accept((IResourceVisitor)this.createResourceVisitor(monitor));
        }
        catch (CoreException e) {
            QVTEditorPlugin.logError("Failed to delete projects markers for " + markerId, e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)this.createDeltaVisitor(monitor));
    }

    protected class DeltaVisitor
    implements IResourceDeltaVisitor {
        protected final IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    AbstractBuilder.this.checkResource(resource, this.monitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    AbstractBuilder.this.checkResource(resource, this.monitor);
                }
            }
            return !this.monitor.isCanceled();
        }
    }

    protected class ResourceVisitor
    implements IResourceVisitor {
        protected final IProgressMonitor monitor;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            AbstractBuilder.this.checkResource(resource, this.monitor);
            return !this.monitor.isCanceled();
        }
    }
}

