/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;

public class CycleAnalysis {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull Set<@NonNull MappingPartitioner> mappingPartitioners;
    protected final @NonNull Set<@NonNull TraceClassAnalysis> traceClassAnalyses;

    public CycleAnalysis(@NonNull TransformationPartitioner transformationPartitioner, @NonNull Set<@NonNull MappingPartitioner> mappingPartitioners, @NonNull Set<@NonNull TraceClassAnalysis> traceClassAnalyses) {
        this.transformationPartitioner = transformationPartitioner;
        this.mappingPartitioners = mappingPartitioners;
        this.traceClassAnalyses = traceClassAnalyses;
        assert (!mappingPartitioners.isEmpty());
        assert (!traceClassAnalyses.isEmpty());
    }

    public @NonNull Iterable<@NonNull MappingPartitioner> getMappingPartitioners() {
        return this.mappingPartitioners;
    }

    public @NonNull Iterable<@NonNull TraceClassAnalysis> getTraceClassAnalyses() {
        return this.traceClassAnalyses;
    }

    public @NonNull Iterable<@NonNull MappingRegion> partition(@NonNull Iterable<@NonNull MappingPartitioner> orderedMappingPartitioners) {
        ArrayList<@NonNull MappingRegion> partitionedRegions = new ArrayList<MappingRegion>();
        for (MappingPartitioner mappingPartitioner : orderedMappingPartitioners) {
            if (!this.mappingPartitioners.contains(mappingPartitioner)) continue;
            Iterables.addAll(partitionedRegions, mappingPartitioner.partition());
        }
        return partitionedRegions;
    }
}

